package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface IngressFluent<A extends IngressFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public IngressFluent.MetadataNested<A> withNewMetadata();
    public IngressFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public IngressFluent.MetadataNested<A> editMetadata();
    public IngressSpec getSpec();
    public A withSpec(IngressSpec spec);
    public IngressFluent.SpecNested<A> withNewSpec();
    public IngressFluent.SpecNested<A> withNewSpecLike(IngressSpec item);
    public IngressFluent.SpecNested<A> editSpec();
    public IngressStatus getStatus();
    public A withStatus(IngressStatus status);
    public IngressFluent.StatusNested<A> withNewStatus();
    public IngressFluent.StatusNested<A> withNewStatusLike(IngressStatus item);
    public IngressFluent.StatusNested<A> editStatus();

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<IngressFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,IngressSpecFluent<IngressFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}
    public interface StatusNested<N> extends Nested<N>,IngressStatusFluent<IngressFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
