package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Boolean;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Long;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;

public interface DeploymentSpecFluent<A extends DeploymentSpecFluent<A>> extends Fluent<A>{


    public Integer getMinReadySeconds();
    public A withMinReadySeconds(Integer minReadySeconds);
    public Boolean isPaused();
    public A withPaused(Boolean paused);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Integer getRevisionHistoryLimit();
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit);
    public RollbackConfig getRollbackTo();
    public A withRollbackTo(RollbackConfig rollbackTo);
    public DeploymentSpecFluent.RollbackToNested<A> withNewRollbackTo();
    public DeploymentSpecFluent.RollbackToNested<A> withNewRollbackToLike(RollbackConfig item);
    public DeploymentSpecFluent.RollbackToNested<A> editRollbackTo();
    public A withNewRollbackTo(Long revision);
    public LabelSelector getSelector();
    public A withSelector(LabelSelector selector);
    public DeploymentSpecFluent.SelectorNested<A> withNewSelector();
    public DeploymentSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
    public DeploymentSpecFluent.SelectorNested<A> editSelector();
    public DeploymentStrategy getStrategy();
    public A withStrategy(DeploymentStrategy strategy);
    public DeploymentSpecFluent.StrategyNested<A> withNewStrategy();
    public DeploymentSpecFluent.StrategyNested<A> withNewStrategyLike(DeploymentStrategy item);
    public DeploymentSpecFluent.StrategyNested<A> editStrategy();
    public PodTemplateSpec getTemplate();
    public A withTemplate(PodTemplateSpec template);
    public DeploymentSpecFluent.TemplateNested<A> withNewTemplate();
    public DeploymentSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
    public DeploymentSpecFluent.TemplateNested<A> editTemplate();

    public interface RollbackToNested<N> extends Nested<N>,RollbackConfigFluent<DeploymentSpecFluent.RollbackToNested<N>>{

        
    public N endRollbackTo();    public N and();
}
    public interface SelectorNested<N> extends Nested<N>,LabelSelectorFluent<DeploymentSpecFluent.SelectorNested<N>>{

        
    public N endSelector();    public N and();
}
    public interface StrategyNested<N> extends Nested<N>,DeploymentStrategyFluent<DeploymentSpecFluent.StrategyNested<N>>{

        
    public N endStrategy();    public N and();
}
    public interface TemplateNested<N> extends Nested<N>,PodTemplateSpecFluent<DeploymentSpecFluent.TemplateNested<N>>{

        
    public N endTemplate();    public N and();
}


}
