package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.util.Map;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ServiceSpecFluent<A extends ServiceSpecFluent<A>> extends Fluent<A>{


    public String getClusterIP();
    public A withClusterIP(String clusterIP);
    public A addToDeprecatedPublicIPs(String... items);
    public A removeFromDeprecatedPublicIPs(String... items);
    public List<String> getDeprecatedPublicIPs();
    public A withDeprecatedPublicIPs(List<String> deprecatedPublicIPs);
    public A withDeprecatedPublicIPs(String... deprecatedPublicIPs);
    public A addToExternalIPs(String... items);
    public A removeFromExternalIPs(String... items);
    public List<String> getExternalIPs();
    public A withExternalIPs(List<String> externalIPs);
    public A withExternalIPs(String... externalIPs);
    public String getLoadBalancerIP();
    public A withLoadBalancerIP(String loadBalancerIP);
    public String getPortalIP();
    public A withPortalIP(String portalIP);
    public A addToPorts(ServicePort... items);
    public A removeFromPorts(ServicePort... items);
    public List<ServicePort> getPorts();
    public A withPorts(List<ServicePort> ports);
    public A withPorts(ServicePort... ports);
    public ServiceSpecFluent.PortsNested<A> addNewPort();
    public ServiceSpecFluent.PortsNested<A> addNewPortLike(ServicePort item);
    public A addToSelector(String key,String value);
    public A addToSelector(Map<String,String> map);
    public A removeFromSelector(String key);
    public A removeFromSelector(Map<String,String> map);
    public Map<String,String> getSelector();
    public A withSelector(Map<String,String> selector);
    public String getSessionAffinity();
    public A withSessionAffinity(String sessionAffinity);
    public String getType();
    public A withType(String type);

    public interface PortsNested<N> extends Nested<N>,ServicePortFluent<ServiceSpecFluent.PortsNested<N>>{

        
    public N endPort();    public N and();
}


}
