package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Boolean;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.String;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Integer;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Long;
import io.fabric8.kubernetes.api.builder.Nested;

public interface SecurityContextConstraintsFluent<A extends SecurityContextConstraintsFluent<A>> extends Fluent<A>{


    public Boolean isAllowHostDirVolumePlugin();
    public A withAllowHostDirVolumePlugin(Boolean allowHostDirVolumePlugin);
    public Boolean isAllowHostIPC();
    public A withAllowHostIPC(Boolean allowHostIPC);
    public Boolean isAllowHostNetwork();
    public A withAllowHostNetwork(Boolean allowHostNetwork);
    public Boolean isAllowHostPID();
    public A withAllowHostPID(Boolean allowHostPID);
    public Boolean isAllowHostPorts();
    public A withAllowHostPorts(Boolean allowHostPorts);
    public Boolean isAllowPrivilegedContainer();
    public A withAllowPrivilegedContainer(Boolean allowPrivilegedContainer);
    public A addToAllowedCapabilities(String... items);
    public A removeFromAllowedCapabilities(String... items);
    public List<String> getAllowedCapabilities();
    public A withAllowedCapabilities(List<String> allowedCapabilities);
    public A withAllowedCapabilities(String... allowedCapabilities);
    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToDefaultAddCapabilities(String... items);
    public A removeFromDefaultAddCapabilities(String... items);
    public List<String> getDefaultAddCapabilities();
    public A withDefaultAddCapabilities(List<String> defaultAddCapabilities);
    public A withDefaultAddCapabilities(String... defaultAddCapabilities);
    public FSGroupStrategyOptions getFsGroup();
    public A withFsGroup(FSGroupStrategyOptions fsGroup);
    public SecurityContextConstraintsFluent.FsGroupNested<A> withNewFsGroup();
    public SecurityContextConstraintsFluent.FsGroupNested<A> withNewFsGroupLike(FSGroupStrategyOptions item);
    public SecurityContextConstraintsFluent.FsGroupNested<A> editFsGroup();
    public A addToGroups(String... items);
    public A removeFromGroups(String... items);
    public List<String> getGroups();
    public A withGroups(List<String> groups);
    public A withGroups(String... groups);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public SecurityContextConstraintsFluent.MetadataNested<A> withNewMetadata();
    public SecurityContextConstraintsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public SecurityContextConstraintsFluent.MetadataNested<A> editMetadata();
    public Integer getPriority();
    public A withPriority(Integer priority);
    public Boolean isReadOnlyRootFilesystem();
    public A withReadOnlyRootFilesystem(Boolean readOnlyRootFilesystem);
    public A addToRequiredDropCapabilities(String... items);
    public A removeFromRequiredDropCapabilities(String... items);
    public List<String> getRequiredDropCapabilities();
    public A withRequiredDropCapabilities(List<String> requiredDropCapabilities);
    public A withRequiredDropCapabilities(String... requiredDropCapabilities);
    public RunAsUserStrategyOptions getRunAsUser();
    public A withRunAsUser(RunAsUserStrategyOptions runAsUser);
    public SecurityContextConstraintsFluent.RunAsUserNested<A> withNewRunAsUser();
    public SecurityContextConstraintsFluent.RunAsUserNested<A> withNewRunAsUserLike(RunAsUserStrategyOptions item);
    public SecurityContextConstraintsFluent.RunAsUserNested<A> editRunAsUser();
    public A withNewRunAsUser(String type,Long uid,Long uidRangeMax,Long uidRangeMin);
    public SELinuxContextStrategyOptions getSeLinuxContext();
    public A withSeLinuxContext(SELinuxContextStrategyOptions seLinuxContext);
    public SecurityContextConstraintsFluent.SeLinuxContextNested<A> withNewSeLinuxContext();
    public SecurityContextConstraintsFluent.SeLinuxContextNested<A> withNewSeLinuxContextLike(SELinuxContextStrategyOptions item);
    public SecurityContextConstraintsFluent.SeLinuxContextNested<A> editSeLinuxContext();
    public SupplementalGroupsStrategyOptions getSupplementalGroups();
    public A withSupplementalGroups(SupplementalGroupsStrategyOptions supplementalGroups);
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> withNewSupplementalGroups();
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> withNewSupplementalGroupsLike(SupplementalGroupsStrategyOptions item);
    public SecurityContextConstraintsFluent.SupplementalGroupsNested<A> editSupplementalGroups();
    public A addToUsers(String... items);
    public A removeFromUsers(String... items);
    public List<String> getUsers();
    public A withUsers(List<String> users);
    public A withUsers(String... users);
    public A addToVolumes(String... items);
    public A removeFromVolumes(String... items);
    public List<String> getVolumes();
    public A withVolumes(List<String> volumes);
    public A withVolumes(String... volumes);

    public interface FsGroupNested<N> extends Nested<N>,FSGroupStrategyOptionsFluent<SecurityContextConstraintsFluent.FsGroupNested<N>>{

        
    public N and();    public N endFsGroup();
}
    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<SecurityContextConstraintsFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface RunAsUserNested<N> extends Nested<N>,RunAsUserStrategyOptionsFluent<SecurityContextConstraintsFluent.RunAsUserNested<N>>{

        
    public N endRunAsUser();    public N and();
}
    public interface SeLinuxContextNested<N> extends Nested<N>,SELinuxContextStrategyOptionsFluent<SecurityContextConstraintsFluent.SeLinuxContextNested<N>>{

        
    public N and();    public N endSeLinuxContext();
}
    public interface SupplementalGroupsNested<N> extends Nested<N>,SupplementalGroupsStrategyOptionsFluent<SecurityContextConstraintsFluent.SupplementalGroupsNested<N>>{

        
    public N and();    public N endSupplementalGroups();
}


}
