package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Object;

public class SecretVolumeSourceFluentImpl<A extends SecretVolumeSourceFluent<A>> extends BaseFluent<A> implements SecretVolumeSourceFluent<A>{

    private String secretName;

    public SecretVolumeSourceFluentImpl(){
    }
    public SecretVolumeSourceFluentImpl(SecretVolumeSource instance){
            this.withSecretName(instance.getSecretName()); 
    }

    public String getSecretName(){
            return this.secretName;
    }

    public A withSecretName(String secretName){
            this.secretName=secretName; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SecretVolumeSourceFluentImpl that = (SecretVolumeSourceFluentImpl) o;
            if (secretName != null ? !secretName.equals(that.secretName) :that.secretName != null) return false;
            return true;
    }




}
