package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface MetadataVolumeSourceFluent<A extends MetadataVolumeSourceFluent<A>> extends Fluent<A>{


    public A addToItems(MetadataFile... items);
    public A removeFromItems(MetadataFile... items);
    public List<MetadataFile> getItems();
    public A withItems(List<MetadataFile> items);
    public A withItems(MetadataFile... items);
    public MetadataVolumeSourceFluent.ItemsNested<A> addNewItem();
    public MetadataVolumeSourceFluent.ItemsNested<A> addNewItemLike(MetadataFile item);

    public interface ItemsNested<N> extends Nested<N>,MetadataFileFluent<MetadataVolumeSourceFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}


}
