package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class BuildTriggerPolicyFluentImpl<T extends BuildTriggerPolicyFluent<T>> extends BaseFluent<T> implements BuildTriggerPolicyFluent<T>{

     VisitableBuilder<WebHookTrigger, ?> generic;     VisitableBuilder<WebHookTrigger, ?> github;     VisitableBuilder<ImageChangeTrigger, ?> imageChange;     String type;     Map<String, Object> additionalProperties = new HashMap();
public BuildTriggerPolicyFluentImpl(){
    
}
public BuildTriggerPolicyFluentImpl( BuildTriggerPolicy instance ){
    this.withGeneric(instance.getGeneric()); this.withGithub(instance.getGithub()); this.withImageChange(instance.getImageChange()); this.withType(instance.getType()); 
}

    public WebHookTrigger getGeneric(){
    return this.generic!=null?this.generic.build():null;
    }
    public T withGeneric( WebHookTrigger generic){
    if (generic!=null){ this.generic= new WebHookTriggerBuilder(generic); _visitables.add(this.generic);} return (T) this;
    }
    public GenericNested<T> withNewGeneric(){
    return new GenericNestedImpl<T>();
    }
    public GenericNested<T> withNewGenericLike( WebHookTrigger item){
    return new GenericNestedImpl<T>(item);
    }
    public GenericNested<T> editGeneric(){
    return withNewGenericLike(getGeneric());
    }
    public T withNewGeneric( Boolean allowEnv,  String secret){
    return withGeneric(new WebHookTrigger(allowEnv, secret));
    }
    public WebHookTrigger getGithub(){
    return this.github!=null?this.github.build():null;
    }
    public T withGithub( WebHookTrigger github){
    if (github!=null){ this.github= new WebHookTriggerBuilder(github); _visitables.add(this.github);} return (T) this;
    }
    public GithubNested<T> withNewGithub(){
    return new GithubNestedImpl<T>();
    }
    public GithubNested<T> withNewGithubLike( WebHookTrigger item){
    return new GithubNestedImpl<T>(item);
    }
    public GithubNested<T> editGithub(){
    return withNewGithubLike(getGithub());
    }
    public T withNewGithub( Boolean allowEnv,  String secret){
    return withGithub(new WebHookTrigger(allowEnv, secret));
    }
    public ImageChangeTrigger getImageChange(){
    return this.imageChange!=null?this.imageChange.build():null;
    }
    public T withImageChange( ImageChangeTrigger imageChange){
    if (imageChange!=null){ this.imageChange= new ImageChangeTriggerBuilder(imageChange); _visitables.add(this.imageChange);} return (T) this;
    }
    public ImageChangeNested<T> withNewImageChange(){
    return new ImageChangeNestedImpl<T>();
    }
    public ImageChangeNested<T> withNewImageChangeLike( ImageChangeTrigger item){
    return new ImageChangeNestedImpl<T>(item);
    }
    public ImageChangeNested<T> editImageChange(){
    return withNewImageChangeLike(getImageChange());
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
BuildTriggerPolicyFluentImpl that = (BuildTriggerPolicyFluentImpl) o;
if (generic != null ? !generic.equals(that.generic) :that.generic != null) return false;
if (github != null ? !github.equals(that.github) :that.github != null) return false;
if (imageChange != null ? !imageChange.equals(that.imageChange) :that.imageChange != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class GenericNestedImpl<N> extends WebHookTriggerFluentImpl<GenericNested<N>> implements GenericNested<N>{

        private final WebHookTriggerBuilder builder;
    
             GenericNestedImpl (){
        this.builder = new WebHookTriggerBuilder(this);
        }
             GenericNestedImpl ( WebHookTrigger item){
        this.builder = new WebHookTriggerBuilder(this, item);
        }
    
            public N endGeneric(){
            return and();
        }
            public N and(){
            return (N) BuildTriggerPolicyFluentImpl.this.withGeneric(builder.build());
        }
    
}
    public class GithubNestedImpl<N> extends WebHookTriggerFluentImpl<GithubNested<N>> implements GithubNested<N>{

        private final WebHookTriggerBuilder builder;
    
             GithubNestedImpl (){
        this.builder = new WebHookTriggerBuilder(this);
        }
             GithubNestedImpl ( WebHookTrigger item){
        this.builder = new WebHookTriggerBuilder(this, item);
        }
    
            public N endGithub(){
            return and();
        }
            public N and(){
            return (N) BuildTriggerPolicyFluentImpl.this.withGithub(builder.build());
        }
    
}
    public class ImageChangeNestedImpl<N> extends ImageChangeTriggerFluentImpl<ImageChangeNested<N>> implements ImageChangeNested<N>{

        private final ImageChangeTriggerBuilder builder;
    
             ImageChangeNestedImpl (){
        this.builder = new ImageChangeTriggerBuilder(this);
        }
             ImageChangeNestedImpl ( ImageChangeTrigger item){
        this.builder = new ImageChangeTriggerBuilder(this, item);
        }
    
            public N and(){
            return (N) BuildTriggerPolicyFluentImpl.this.withImageChange(builder.build());
        }
            public N endImageChange(){
            return and();
        }
    
}


}
