package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class DeploymentStatusBuilder extends DeploymentStatusFluentImpl<DeploymentStatusBuilder> implements VisitableBuilder<DeploymentStatus,DeploymentStatusBuilder>{

     DeploymentStatusFluent<?> fluent;
public DeploymentStatusBuilder(){
    this(new DeploymentStatus());
}
public DeploymentStatusBuilder( DeploymentStatusFluent<?> fluent ){
    this(fluent, new DeploymentStatus());
}
public DeploymentStatusBuilder( DeploymentStatusFluent<?> fluent , DeploymentStatus instance ){
    this.fluent = fluent; fluent.withAvailableReplicas(instance.getAvailableReplicas()); fluent.withObservedGeneration(instance.getObservedGeneration()); fluent.withReplicas(instance.getReplicas()); fluent.withUnavailableReplicas(instance.getUnavailableReplicas()); fluent.withUpdatedReplicas(instance.getUpdatedReplicas()); 
}
public DeploymentStatusBuilder( DeploymentStatus instance ){
    this.fluent = this; this.withAvailableReplicas(instance.getAvailableReplicas()); this.withObservedGeneration(instance.getObservedGeneration()); this.withReplicas(instance.getReplicas()); this.withUnavailableReplicas(instance.getUnavailableReplicas()); this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
}

public EditableDeploymentStatus build(){
    EditableDeploymentStatus buildable = new EditableDeploymentStatus(fluent.getAvailableReplicas(),fluent.getObservedGeneration(),fluent.getReplicas(),fluent.getUnavailableReplicas(),fluent.getUpdatedReplicas());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
DeploymentStatusBuilder that = (DeploymentStatusBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
