package io.fabric8.kubernetes.api.model.extensions;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class DeploymentRollbackFluentImpl<T extends DeploymentRollbackFluent<T>> extends BaseFluent<T> implements DeploymentRollbackFluent<T>{

     String apiVersion;     String kind;     String name;     VisitableBuilder<RollbackConfig, ?> rollbackTo;     Map<String, String> updatedAnnotations = new HashMap();     Map<String, Object> additionalProperties = new HashMap();
public DeploymentRollbackFluentImpl(){
    
}
public DeploymentRollbackFluentImpl( DeploymentRollback instance ){
    this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withName(instance.getName()); this.withRollbackTo(instance.getRollbackTo()); this.withUpdatedAnnotations(instance.getUpdatedAnnotations()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public RollbackConfig getRollbackTo(){
    return this.rollbackTo!=null?this.rollbackTo.build():null;
    }
    public T withRollbackTo( RollbackConfig rollbackTo){
    if (rollbackTo!=null){ this.rollbackTo= new RollbackConfigBuilder(rollbackTo); _visitables.add(this.rollbackTo);} return (T) this;
    }
    public RollbackToNested<T> withNewRollbackTo(){
    return new RollbackToNestedImpl<T>();
    }
    public RollbackToNested<T> withNewRollbackToLike( RollbackConfig item){
    return new RollbackToNestedImpl<T>(item);
    }
    public RollbackToNested<T> editRollbackTo(){
    return withNewRollbackToLike(getRollbackTo());
    }
    public T withNewRollbackTo( Long revision){
    return withRollbackTo(new RollbackConfig(revision));
    }
    public T addToUpdatedAnnotations( String key,  String value){
    if(key != null && value != null) {this.updatedAnnotations.put(key, value);} return (T)this;
    }
    public T addToUpdatedAnnotations( Map<String, String> map){
    if(map != null) { this.updatedAnnotations.putAll(map);} return (T)this;
    }
    public T removeFromUpdatedAnnotations( String key){
    if(key != null) {this.updatedAnnotations.remove(key);} return (T)this;
    }
    public T removeFromUpdatedAnnotations( Map<String, String> map){
    if(map != null) { for(Object key : map.keySet()) {this.updatedAnnotations.remove(key);}} return (T)this;
    }
    public Map<String, String> getUpdatedAnnotations(){
    return this.updatedAnnotations;
    }
    public T withUpdatedAnnotations( Map<String, String> updatedAnnotations){
    this.updatedAnnotations.clear();if (updatedAnnotations != null) {this.updatedAnnotations.putAll(updatedAnnotations);} return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DeploymentRollbackFluentImpl that = (DeploymentRollbackFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (rollbackTo != null ? !rollbackTo.equals(that.rollbackTo) :that.rollbackTo != null) return false;
if (updatedAnnotations != null ? !updatedAnnotations.equals(that.updatedAnnotations) :that.updatedAnnotations != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class RollbackToNestedImpl<N> extends RollbackConfigFluentImpl<RollbackToNested<N>> implements RollbackToNested<N>{

        private final RollbackConfigBuilder builder;
    
             RollbackToNestedImpl (){
        this.builder = new RollbackConfigBuilder(this);
        }
             RollbackToNestedImpl ( RollbackConfig item){
        this.builder = new RollbackConfigBuilder(this, item);
        }
    
            public N endRollbackTo(){
            return and();
        }
            public N and(){
            return (N) DeploymentRollbackFluentImpl.this.withRollbackTo(builder.build());
        }
    
}


}
