package io.fabric8.openshift.api.model;

import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;

public interface IdentityFluent<T extends IdentityFluent<T>> extends Fluent<T>{


    public String getApiVersion();    public T withApiVersion( String apiVersion);    public T addToExtra( String key,  String value);    public T addToExtra( Map<String, String> map);    public T removeFromExtra( String key);    public T removeFromExtra( Map<String, String> map);    public Map<String, String> getExtra();    public T withExtra( Map<String, String> extra);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public String getProviderName();    public T withProviderName( String providerName);    public String getProviderUserName();    public T withProviderUserName( String providerUserName);    public ObjectReference getUser();    public T withUser( ObjectReference user);    public UserNested<T> withNewUser();    public UserNested<T> withNewUserLike( ObjectReference item);    public UserNested<T> editUser();    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface UserNested<N> extends Nested<N>, ObjectReferenceFluent<UserNested<N>>{
            public N and();            public N endUser();        
}


}
