package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class TCPSocketActionFluentImpl<T extends TCPSocketActionFluent<T>> extends BaseFluent<T> implements TCPSocketActionFluent<T>{

     VisitableBuilder<IntOrString, ?> port;     Map<String, Object> additionalProperties = new HashMap();
public TCPSocketActionFluentImpl(){
    
}
public TCPSocketActionFluentImpl( TCPSocketAction instance ){
    this.withPort(instance.getPort()); 
}

    public IntOrString getPort(){
    return this.port!=null?this.port.build():null;
    }
    public T withPort( IntOrString port){
    if (port!=null){ this.port= new IntOrStringBuilder(port); _visitables.add(this.port);} return (T) this;
    }
    public PortNested<T> withNewPort(){
    return new PortNestedImpl<T>();
    }
    public PortNested<T> withNewPortLike( IntOrString item){
    return new PortNestedImpl<T>(item);
    }
    public PortNested<T> editPort(){
    return withNewPortLike(getPort());
    }
    public T withNewPort( String strVal){
    return withPort(new IntOrString(strVal));
    }
    public T withNewPort( Integer intVal){
    return withPort(new IntOrString(intVal));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
TCPSocketActionFluentImpl that = (TCPSocketActionFluentImpl) o;
if (port != null ? !port.equals(that.port) :that.port != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class PortNestedImpl<N> extends IntOrStringFluentImpl<PortNested<N>> implements PortNested<N>{

        private final IntOrStringBuilder builder;
    
             PortNestedImpl (){
        this.builder = new IntOrStringBuilder(this);
        }
             PortNestedImpl ( IntOrString item){
        this.builder = new IntOrStringBuilder(this, item);
        }
    
            public N endPort(){
            return and();
        }
            public N and(){
            return (N) TCPSocketActionFluentImpl.this.withPort(builder.build());
        }
    
}


}
