package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class ScopeRestrictionFluentImpl<T extends ScopeRestrictionFluent<T>> extends BaseFluent<T> implements ScopeRestrictionFluent<T>{

     VisitableBuilder<ClusterRoleScopeRestriction, ?> clusterRole;     List<String> literals = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public ScopeRestrictionFluentImpl(){
    
}
public ScopeRestrictionFluentImpl( ScopeRestriction instance ){
    this.withClusterRole(instance.getClusterRole()); this.withLiterals(instance.getLiterals()); 
}

    public ClusterRoleScopeRestriction getClusterRole(){
    return this.clusterRole!=null?this.clusterRole.build():null;
    }
    public T withClusterRole( ClusterRoleScopeRestriction clusterRole){
    if (clusterRole!=null){ this.clusterRole= new ClusterRoleScopeRestrictionBuilder(clusterRole); _visitables.add(this.clusterRole);} return (T) this;
    }
    public ClusterRoleNested<T> withNewClusterRole(){
    return new ClusterRoleNestedImpl<T>();
    }
    public ClusterRoleNested<T> withNewClusterRoleLike( ClusterRoleScopeRestriction item){
    return new ClusterRoleNestedImpl<T>(item);
    }
    public ClusterRoleNested<T> editClusterRole(){
    return withNewClusterRoleLike(getClusterRole());
    }
    public T addToLiterals( String ...items){
    for (String item : items) {this.literals.add(item);} return (T)this;
    }
    public T removeFromLiterals( String ...items){
    for (String item : items) {this.literals.remove(item);} return (T)this;
    }
    public List<String> getLiterals(){
    return this.literals;
    }
    public T withLiterals( List<String> literals){
    this.literals.clear();if (literals != null) {for (String item : literals){this.addToLiterals(item);}} return (T) this;
    }
    public T withLiterals( String ...literals){
    this.literals.clear(); if (literals != null) {for (String item :literals){ this.addToLiterals(item);}} return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ScopeRestrictionFluentImpl that = (ScopeRestrictionFluentImpl) o;
if (clusterRole != null ? !clusterRole.equals(that.clusterRole) :that.clusterRole != null) return false;
if (literals != null ? !literals.equals(that.literals) :that.literals != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ClusterRoleNestedImpl<N> extends ClusterRoleScopeRestrictionFluentImpl<ClusterRoleNested<N>> implements ClusterRoleNested<N>{

        private final ClusterRoleScopeRestrictionBuilder builder;
    
             ClusterRoleNestedImpl (){
        this.builder = new ClusterRoleScopeRestrictionBuilder(this);
        }
             ClusterRoleNestedImpl ( ClusterRoleScopeRestriction item){
        this.builder = new ClusterRoleScopeRestrictionBuilder(this, item);
        }
    
            public N and(){
            return (N) ScopeRestrictionFluentImpl.this.withClusterRole(builder.build());
        }
            public N endClusterRole(){
            return and();
        }
    
}


}
