package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface RouteIngressFluent<T extends RouteIngressFluent<T>> extends Fluent<T>{


    public T addToConditions( RouteIngressCondition ...items);    public T removeFromConditions( RouteIngressCondition ...items);    public List<RouteIngressCondition> getConditions();    public T withConditions( List<RouteIngressCondition> conditions);    public T withConditions( RouteIngressCondition ...conditions);    public ConditionsNested<T> addNewCondition();    public ConditionsNested<T> addNewConditionLike( RouteIngressCondition item);    public T addNewCondition( String lastTransitionTime,  String message,  String reason,  String status,  String type);    public String getHost();    public T withHost( String host);    public String getRouterName();    public T withRouterName( String routerName);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface ConditionsNested<N> extends Nested<N>, RouteIngressConditionFluent<ConditionsNested<N>>{
            public N endCondition();            public N and();        
}


}
