package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ServiceSpecBuilder extends ServiceSpecFluentImpl<ServiceSpecBuilder> implements VisitableBuilder<ServiceSpec,ServiceSpecBuilder>{

     ServiceSpecFluent<?> fluent;
public ServiceSpecBuilder(){
    this(new ServiceSpec());
}
public ServiceSpecBuilder( ServiceSpecFluent<?> fluent ){
    this(fluent, new ServiceSpec());
}
public ServiceSpecBuilder( ServiceSpecFluent<?> fluent , ServiceSpec instance ){
    this.fluent = fluent; fluent.withClusterIP(instance.getClusterIP()); fluent.withDeprecatedPublicIPs(instance.getDeprecatedPublicIPs()); fluent.withExternalIPs(instance.getExternalIPs()); fluent.withLoadBalancerIP(instance.getLoadBalancerIP()); fluent.withPortalIP(instance.getPortalIP()); fluent.withPorts(instance.getPorts()); fluent.withSelector(instance.getSelector()); fluent.withSessionAffinity(instance.getSessionAffinity()); fluent.withType(instance.getType()); 
}
public ServiceSpecBuilder( ServiceSpec instance ){
    this.fluent = this; this.withClusterIP(instance.getClusterIP()); this.withDeprecatedPublicIPs(instance.getDeprecatedPublicIPs()); this.withExternalIPs(instance.getExternalIPs()); this.withLoadBalancerIP(instance.getLoadBalancerIP()); this.withPortalIP(instance.getPortalIP()); this.withPorts(instance.getPorts()); this.withSelector(instance.getSelector()); this.withSessionAffinity(instance.getSessionAffinity()); this.withType(instance.getType()); 
}

public EditableServiceSpec build(){
    EditableServiceSpec buildable = new EditableServiceSpec(fluent.getClusterIP(),fluent.getDeprecatedPublicIPs(),fluent.getExternalIPs(),fluent.getLoadBalancerIP(),fluent.getPortalIP(),fluent.getPorts(),fluent.getSelector(),fluent.getSessionAffinity(),fluent.getType());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ServiceSpecBuilder that = (ServiceSpecBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
