package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.Map;
import java.util.Map;
import java.util.HashMap;
import java.io.Serializable;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class JobSpecBuilder extends JobSpecFluentImpl<JobSpecBuilder> implements VisitableBuilder<JobSpec,JobSpecBuilder>{

     JobSpecFluent<?> fluent;
public JobSpecBuilder(){
    this(new JobSpec());
}
public JobSpecBuilder( JobSpecFluent<?> fluent ){
    this(fluent, new JobSpec());
}
public JobSpecBuilder( JobSpecFluent<?> fluent , JobSpec instance ){
    this.fluent = fluent; fluent.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); fluent.withAutoSelector(instance.getAutoSelector()); fluent.withCompletions(instance.getCompletions()); fluent.withParallelism(instance.getParallelism()); fluent.withSelector(instance.getSelector()); fluent.withTemplate(instance.getTemplate()); 
}
public JobSpecBuilder( JobSpec instance ){
    this.fluent = this; this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); this.withAutoSelector(instance.getAutoSelector()); this.withCompletions(instance.getCompletions()); this.withParallelism(instance.getParallelism()); this.withSelector(instance.getSelector()); this.withTemplate(instance.getTemplate()); 
}

public EditableJobSpec build(){
    EditableJobSpec buildable = new EditableJobSpec(fluent.getActiveDeadlineSeconds(),fluent.isAutoSelector(),fluent.getCompletions(),fluent.getParallelism(),fluent.getSelector(),fluent.getTemplate());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
JobSpecBuilder that = (JobSpecBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
