package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class APIVersionBuilder extends APIVersionFluentImpl<APIVersionBuilder> implements VisitableBuilder<APIVersion,APIVersionBuilder>{

     APIVersionFluent<?> fluent;
public APIVersionBuilder(){
    this(new APIVersion());
}
public APIVersionBuilder( APIVersionFluent<?> fluent ){
    this(fluent, new APIVersion());
}
public APIVersionBuilder( APIVersionFluent<?> fluent , APIVersion instance ){
    this.fluent = fluent; fluent.withName(instance.getName()); 
}
public APIVersionBuilder( APIVersion instance ){
    this.fluent = this; this.withName(instance.getName()); 
}

public EditableAPIVersion build(){
    EditableAPIVersion buildable = new EditableAPIVersion(fluent.getName());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
APIVersionBuilder that = (APIVersionBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
