package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class RBDVolumeSourceFluentImpl<T extends RBDVolumeSourceFluent<T>> extends BaseFluent<T> implements RBDVolumeSourceFluent<T>{

     String fsType;     String image;     String keyring;     List<String> monitors = new ArrayList();     String pool;     Boolean readOnly;     VisitableBuilder<LocalObjectReference, ?> secretRef;     String user;     Map<String, Object> additionalProperties = new HashMap();
public RBDVolumeSourceFluentImpl(){
    
}
public RBDVolumeSourceFluentImpl( RBDVolumeSource instance ){
    this.withFsType(instance.getFsType()); this.withImage(instance.getImage()); this.withKeyring(instance.getKeyring()); this.withMonitors(instance.getMonitors()); this.withPool(instance.getPool()); this.withReadOnly(instance.getReadOnly()); this.withSecretRef(instance.getSecretRef()); this.withUser(instance.getUser()); 
}

    public String getFsType(){
    return this.fsType;
    }
    public T withFsType( String fsType){
    this.fsType=fsType; return (T) this;
    }
    public String getImage(){
    return this.image;
    }
    public T withImage( String image){
    this.image=image; return (T) this;
    }
    public String getKeyring(){
    return this.keyring;
    }
    public T withKeyring( String keyring){
    this.keyring=keyring; return (T) this;
    }
    public T addToMonitors( String ...items){
    for (String item : items) {this.monitors.add(item);} return (T)this;
    }
    public T removeFromMonitors( String ...items){
    for (String item : items) {this.monitors.remove(item);} return (T)this;
    }
    public List<String> getMonitors(){
    return this.monitors;
    }
    public T withMonitors( List<String> monitors){
    this.monitors.clear();if (monitors != null) {for (String item : monitors){this.addToMonitors(item);}} return (T) this;
    }
    public T withMonitors( String ...monitors){
    this.monitors.clear(); if (monitors != null) {for (String item :monitors){ this.addToMonitors(item);}} return (T) this;
    }
    public String getPool(){
    return this.pool;
    }
    public T withPool( String pool){
    this.pool=pool; return (T) this;
    }
    public Boolean isReadOnly(){
    return this.readOnly;
    }
    public T withReadOnly( Boolean readOnly){
    this.readOnly=readOnly; return (T) this;
    }
    public LocalObjectReference getSecretRef(){
    return this.secretRef!=null?this.secretRef.build():null;
    }
    public T withSecretRef( LocalObjectReference secretRef){
    if (secretRef!=null){ this.secretRef= new LocalObjectReferenceBuilder(secretRef); _visitables.add(this.secretRef);} return (T) this;
    }
    public SecretRefNested<T> withNewSecretRef(){
    return new SecretRefNestedImpl<T>();
    }
    public SecretRefNested<T> withNewSecretRefLike( LocalObjectReference item){
    return new SecretRefNestedImpl<T>(item);
    }
    public SecretRefNested<T> editSecretRef(){
    return withNewSecretRefLike(getSecretRef());
    }
    public T withNewSecretRef( String name){
    return withSecretRef(new LocalObjectReference(name));
    }
    public String getUser(){
    return this.user;
    }
    public T withUser( String user){
    this.user=user; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
RBDVolumeSourceFluentImpl that = (RBDVolumeSourceFluentImpl) o;
if (fsType != null ? !fsType.equals(that.fsType) :that.fsType != null) return false;
if (image != null ? !image.equals(that.image) :that.image != null) return false;
if (keyring != null ? !keyring.equals(that.keyring) :that.keyring != null) return false;
if (monitors != null ? !monitors.equals(that.monitors) :that.monitors != null) return false;
if (pool != null ? !pool.equals(that.pool) :that.pool != null) return false;
if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
if (secretRef != null ? !secretRef.equals(that.secretRef) :that.secretRef != null) return false;
if (user != null ? !user.equals(that.user) :that.user != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class SecretRefNestedImpl<N> extends LocalObjectReferenceFluentImpl<SecretRefNested<N>> implements SecretRefNested<N>{

        private final LocalObjectReferenceBuilder builder;
    
             SecretRefNestedImpl (){
        this.builder = new LocalObjectReferenceBuilder(this);
        }
             SecretRefNestedImpl ( LocalObjectReference item){
        this.builder = new LocalObjectReferenceBuilder(this, item);
        }
    
            public N endSecretRef(){
            return and();
        }
            public N and(){
            return (N) RBDVolumeSourceFluentImpl.this.withSecretRef(builder.build());
        }
    
}


}
