package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class OAuthClientBuilder extends OAuthClientFluentImpl<OAuthClientBuilder> implements VisitableBuilder<OAuthClient,OAuthClientBuilder>{

     OAuthClientFluent<?> fluent;
public OAuthClientBuilder(){
    this(new OAuthClient());
}
public OAuthClientBuilder( OAuthClientFluent<?> fluent ){
    this(fluent, new OAuthClient());
}
public OAuthClientBuilder( OAuthClientFluent<?> fluent , OAuthClient instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withKind(instance.getKind()); fluent.withMetadata(instance.getMetadata()); fluent.withRedirectURIs(instance.getRedirectURIs()); fluent.withRespondWithChallenges(instance.getRespondWithChallenges()); fluent.withSecret(instance.getSecret()); 
}
public OAuthClientBuilder( OAuthClient instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withRedirectURIs(instance.getRedirectURIs()); this.withRespondWithChallenges(instance.getRespondWithChallenges()); this.withSecret(instance.getSecret()); 
}

public EditableOAuthClient build(){
    EditableOAuthClient buildable = new EditableOAuthClient(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getRedirectURIs(),fluent.isRespondWithChallenges(),fluent.getSecret());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
OAuthClientBuilder that = (OAuthClientBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
