package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ImageFluent<T extends ImageFluent<T>> extends Fluent<T>{


    public String getApiVersion();    public T withApiVersion( String apiVersion);    public T addToDockerImageLayers( ImageLayer ...items);    public T removeFromDockerImageLayers( ImageLayer ...items);    public List<ImageLayer> getDockerImageLayers();    public T withDockerImageLayers( List<ImageLayer> dockerImageLayers);    public T withDockerImageLayers( ImageLayer ...dockerImageLayers);    public DockerImageLayersNested<T> addNewDockerImageLayer();    public DockerImageLayersNested<T> addNewDockerImageLayerLike( ImageLayer item);    public T addNewDockerImageLayer( String name,  Long size);    public String getDockerImageManifest();    public T withDockerImageManifest( String dockerImageManifest);    public HasMetadata getDockerImageMetadata();    public T withDockerImageMetadata( HasMetadata dockerImageMetadata);    public String getDockerImageMetadataVersion();    public T withDockerImageMetadataVersion( String dockerImageMetadataVersion);    public String getDockerImageReference();    public T withDockerImageReference( String dockerImageReference);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface DockerImageLayersNested<N> extends Nested<N>, ImageLayerFluent<DockerImageLayersNested<N>>{
            public N and();            public N endDockerImageLayer();        
}

    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}


}
