package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.List;
import java.util.AbstractList;
import java.util.HashMap;
import java.util.List;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface PodStatusFluent<T extends PodStatusFluent<T>> extends Fluent<T>{


    public T addToConditions( PodCondition ...items);    public T removeFromConditions( PodCondition ...items);    public List<PodCondition> getConditions();    public T withConditions( List<PodCondition> conditions);    public T withConditions( PodCondition ...conditions);    public ConditionsNested<T> addNewCondition();    public ConditionsNested<T> addNewConditionLike( PodCondition item);    public T addToContainerStatuses( ContainerStatus ...items);    public T removeFromContainerStatuses( ContainerStatus ...items);    public List<ContainerStatus> getContainerStatuses();    public T withContainerStatuses( List<ContainerStatus> containerStatuses);    public T withContainerStatuses( ContainerStatus ...containerStatuses);    public ContainerStatusesNested<T> addNewContainerStatuse();    public ContainerStatusesNested<T> addNewContainerStatuseLike( ContainerStatus item);    public String getHostIP();    public T withHostIP( String hostIP);    public String getMessage();    public T withMessage( String message);    public String getPhase();    public T withPhase( String phase);    public String getPodIP();    public T withPodIP( String podIP);    public String getReason();    public T withReason( String reason);    public String getStartTime();    public T withStartTime( String startTime);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface ConditionsNested<N> extends Nested<N>, PodConditionFluent<ConditionsNested<N>>{
            public N endCondition();            public N and();        
}

    public interface ContainerStatusesNested<N> extends Nested<N>, ContainerStatusFluent<ContainerStatusesNested<N>>{
            public N endContainerStatuse();            public N and();        
}


}
