package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface HTTPGetActionFluent<T extends HTTPGetActionFluent<T>> extends Fluent<T>{


    public String getHost();    public T withHost( String host);    public T addToHttpHeaders( HTTPHeader ...items);    public T removeFromHttpHeaders( HTTPHeader ...items);    public List<HTTPHeader> getHttpHeaders();    public T withHttpHeaders( List<HTTPHeader> httpHeaders);    public T withHttpHeaders( HTTPHeader ...httpHeaders);    public HttpHeadersNested<T> addNewHttpHeader();    public HttpHeadersNested<T> addNewHttpHeaderLike( HTTPHeader item);    public T addNewHttpHeader( String name,  String value);    public String getPath();    public T withPath( String path);    public IntOrString getPort();    public T withPort( IntOrString port);    public PortNested<T> withNewPort();    public PortNested<T> withNewPortLike( IntOrString item);    public PortNested<T> editPort();    public T withNewPort( String strVal);    public T withNewPort( Integer intVal);    public String getScheme();    public T withScheme( String scheme);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface HttpHeadersNested<N> extends Nested<N>, HTTPHeaderFluent<HttpHeadersNested<N>>{
            public N endHttpHeader();            public N and();        
}

    public interface PortNested<N> extends Nested<N>, IntOrStringFluent<PortNested<N>>{
            public N endPort();            public N and();        
}


}
