package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ContainerImageFluentImpl<T extends ContainerImageFluent<T>> extends BaseFluent<T> implements ContainerImageFluent<T>{

     List<String> names = new ArrayList();     Long sizeBytes;     Map<String, Object> additionalProperties = new HashMap();
public ContainerImageFluentImpl(){
    
}
public ContainerImageFluentImpl( ContainerImage instance ){
    this.withNames(instance.getNames()); this.withSizeBytes(instance.getSizeBytes()); 
}

    public T addToNames( String ...items){
    for (String item : items) {this.names.add(item);} return (T)this;
    }
    public T removeFromNames( String ...items){
    for (String item : items) {this.names.remove(item);} return (T)this;
    }
    public List<String> getNames(){
    return this.names;
    }
    public T withNames( List<String> names){
    this.names.clear();if (names != null) {for (String item : names){this.addToNames(item);}} return (T) this;
    }
    public T withNames( String ...names){
    this.names.clear(); if (names != null) {for (String item :names){ this.addToNames(item);}} return (T) this;
    }
    public Long getSizeBytes(){
    return this.sizeBytes;
    }
    public T withSizeBytes( Long sizeBytes){
    this.sizeBytes=sizeBytes; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ContainerImageFluentImpl that = (ContainerImageFluentImpl) o;
if (names != null ? !names.equals(that.names) :that.names != null) return false;
if (sizeBytes != null ? !sizeBytes.equals(that.sizeBytes) :that.sizeBytes != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
