package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface GitSourceRevisionFluent<T extends GitSourceRevisionFluent<T>> extends Fluent<T>{


    public SourceControlUser getAuthor();    public T withAuthor( SourceControlUser author);    public AuthorNested<T> withNewAuthor();    public AuthorNested<T> withNewAuthorLike( SourceControlUser item);    public AuthorNested<T> editAuthor();    public T withNewAuthor( String email,  String name);    public String getCommit();    public T withCommit( String commit);    public SourceControlUser getCommitter();    public T withCommitter( SourceControlUser committer);    public CommitterNested<T> withNewCommitter();    public CommitterNested<T> withNewCommitterLike( SourceControlUser item);    public CommitterNested<T> editCommitter();    public T withNewCommitter( String email,  String name);    public String getMessage();    public T withMessage( String message);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface AuthorNested<N> extends Nested<N>, SourceControlUserFluent<AuthorNested<N>>{
            public N and();            public N endAuthor();        
}

    public interface CommitterNested<N> extends Nested<N>, SourceControlUserFluent<CommitterNested<N>>{
            public N and();            public N endCommitter();        
}


}
