package io.fabric8.kubernetes.api.model.extensions;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.List;

public class LabelSelectorFluentImpl<T extends LabelSelectorFluent<T>> extends BaseFluent<T> implements LabelSelectorFluent<T>{

     List<VisitableBuilder<LabelSelectorRequirement, ?>> matchExpressions = new ArrayList();     Map<String, String> matchLabels = new HashMap();     Map<String, Object> additionalProperties = new HashMap();
public LabelSelectorFluentImpl(){
    
}
public LabelSelectorFluentImpl( LabelSelector instance ){
    this.withMatchExpressions(instance.getMatchExpressions()); this.withMatchLabels(instance.getMatchLabels()); 
}

    public T addToMatchExpressions( LabelSelectorRequirement ...items){
    for (LabelSelectorRequirement item : items) {LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);_visitables.add(builder);this.matchExpressions.add(builder);} return (T)this;
    }
    public T removeFromMatchExpressions( LabelSelectorRequirement ...items){
    for (LabelSelectorRequirement item : items) {LabelSelectorRequirementBuilder builder = new LabelSelectorRequirementBuilder(item);_visitables.remove(builder);this.matchExpressions.remove(builder);} return (T)this;
    }
    public List<LabelSelectorRequirement> getMatchExpressions(){
    return build(matchExpressions);
    }
    public T withMatchExpressions( List<LabelSelectorRequirement> matchExpressions){
    this.matchExpressions.clear();if (matchExpressions != null) {for (LabelSelectorRequirement item : matchExpressions){this.addToMatchExpressions(item);}} return (T) this;
    }
    public T withMatchExpressions( LabelSelectorRequirement ...matchExpressions){
    this.matchExpressions.clear(); if (matchExpressions != null) {for (LabelSelectorRequirement item :matchExpressions){ this.addToMatchExpressions(item);}} return (T) this;
    }
    public MatchExpressionsNested<T> addNewMatchExpression(){
    return new MatchExpressionsNestedImpl<T>();
    }
    public MatchExpressionsNested<T> addNewMatchExpressionLike( LabelSelectorRequirement item){
    return new MatchExpressionsNestedImpl<T>(item);
    }
    public T addToMatchLabels( String key,  String value){
    if(key != null && value != null) {this.matchLabels.put(key, value);} return (T)this;
    }
    public T addToMatchLabels( Map<String, String> map){
    if(map != null) { this.matchLabels.putAll(map);} return (T)this;
    }
    public T removeFromMatchLabels( String key){
    if(key != null) {this.matchLabels.remove(key);} return (T)this;
    }
    public T removeFromMatchLabels( Map<String, String> map){
    if(map != null) { for(Object key : map.keySet()) {this.matchLabels.remove(key);}} return (T)this;
    }
    public Map<String, String> getMatchLabels(){
    return this.matchLabels;
    }
    public T withMatchLabels( Map<String, String> matchLabels){
    this.matchLabels.clear();if (matchLabels != null) {this.matchLabels.putAll(matchLabels);} return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
LabelSelectorFluentImpl that = (LabelSelectorFluentImpl) o;
if (matchExpressions != null ? !matchExpressions.equals(that.matchExpressions) :that.matchExpressions != null) return false;
if (matchLabels != null ? !matchLabels.equals(that.matchLabels) :that.matchLabels != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MatchExpressionsNestedImpl<N> extends LabelSelectorRequirementFluentImpl<MatchExpressionsNested<N>> implements MatchExpressionsNested<N>{

        private final LabelSelectorRequirementBuilder builder;
    
             MatchExpressionsNestedImpl (){
        this.builder = new LabelSelectorRequirementBuilder(this);
        }
             MatchExpressionsNestedImpl ( LabelSelectorRequirement item){
        this.builder = new LabelSelectorRequirementBuilder(this, item);
        }
    
            public N endMatchExpression(){
            return and();
        }
            public N and(){
            return (N) LabelSelectorFluentImpl.this.addToMatchExpressions(builder.build());
        }
    
}


}
