package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface EnvVarSourceFluent<T extends EnvVarSourceFluent<T>> extends Fluent<T>{


    public ConfigMapKeySelector getConfigMapKeyRef();    public T withConfigMapKeyRef( ConfigMapKeySelector configMapKeyRef);    public ConfigMapKeyRefNested<T> withNewConfigMapKeyRef();    public ConfigMapKeyRefNested<T> withNewConfigMapKeyRefLike( ConfigMapKeySelector item);    public ConfigMapKeyRefNested<T> editConfigMapKeyRef();    public T withNewConfigMapKeyRef( String key,  String name);    public ObjectFieldSelector getFieldRef();    public T withFieldRef( ObjectFieldSelector fieldRef);    public FieldRefNested<T> withNewFieldRef();    public FieldRefNested<T> withNewFieldRefLike( ObjectFieldSelector item);    public FieldRefNested<T> editFieldRef();    public T withNewFieldRef( String apiVersion,  String fieldPath);    public SecretKeySelector getSecretKeyRef();    public T withSecretKeyRef( SecretKeySelector secretKeyRef);    public SecretKeyRefNested<T> withNewSecretKeyRef();    public SecretKeyRefNested<T> withNewSecretKeyRefLike( SecretKeySelector item);    public SecretKeyRefNested<T> editSecretKeyRef();    public T withNewSecretKeyRef( String key,  String name);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface ConfigMapKeyRefNested<N> extends Nested<N>, ConfigMapKeySelectorFluent<ConfigMapKeyRefNested<N>>{
            public N endConfigMapKeyRef();            public N and();        
}

    public interface FieldRefNested<N> extends Nested<N>, ObjectFieldSelectorFluent<FieldRefNested<N>>{
            public N and();            public N endFieldRef();        
}

    public interface SecretKeyRefNested<N> extends Nested<N>, SecretKeySelectorFluent<SecretKeyRefNested<N>>{
            public N endSecretKeyRef();            public N and();        
}


}
