package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.HasMetadata;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public class NamedClusterRoleFluentImpl<T extends NamedClusterRoleFluent<T>> extends BaseFluent<T> implements NamedClusterRoleFluent<T>{

     String name;     VisitableBuilder<ClusterRole, ?> role;     Map<String, Object> additionalProperties = new HashMap();
public NamedClusterRoleFluentImpl(){
    
}
public NamedClusterRoleFluentImpl( NamedClusterRole instance ){
    this.withName(instance.getName()); this.withRole(instance.getRole()); 
}

    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public ClusterRole getRole(){
    return this.role!=null?this.role.build():null;
    }
    public T withRole( ClusterRole role){
    if (role!=null){ this.role= new ClusterRoleBuilder(role); _visitables.add(this.role);} return (T) this;
    }
    public RoleNested<T> withNewRole(){
    return new RoleNestedImpl<T>();
    }
    public RoleNested<T> withNewRoleLike( ClusterRole item){
    return new RoleNestedImpl<T>(item);
    }
    public RoleNested<T> editRole(){
    return withNewRoleLike(getRole());
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
NamedClusterRoleFluentImpl that = (NamedClusterRoleFluentImpl) o;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (role != null ? !role.equals(that.role) :that.role != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class RoleNestedImpl<N> extends ClusterRoleFluentImpl<RoleNested<N>> implements RoleNested<N>{

        private final ClusterRoleBuilder builder;
    
             RoleNestedImpl (){
        this.builder = new ClusterRoleBuilder(this);
        }
             RoleNestedImpl ( ClusterRole item){
        this.builder = new ClusterRoleBuilder(this, item);
        }
    
            public N endRole(){
            return and();
        }
            public N and(){
            return (N) NamedClusterRoleFluentImpl.this.withRole(builder.build());
        }
    
}


}
