package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ImageSourcePathFluentImpl<T extends ImageSourcePathFluent<T>> extends BaseFluent<T> implements ImageSourcePathFluent<T>{

     String destinationDir;     String sourcePath;     Map<String, Object> additionalProperties = new HashMap();
public ImageSourcePathFluentImpl(){
    
}
public ImageSourcePathFluentImpl( ImageSourcePath instance ){
    this.withDestinationDir(instance.getDestinationDir()); this.withSourcePath(instance.getSourcePath()); 
}

    public String getDestinationDir(){
    return this.destinationDir;
    }
    public T withDestinationDir( String destinationDir){
    this.destinationDir=destinationDir; return (T) this;
    }
    public String getSourcePath(){
    return this.sourcePath;
    }
    public T withSourcePath( String sourcePath){
    this.sourcePath=sourcePath; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ImageSourcePathFluentImpl that = (ImageSourcePathFluentImpl) o;
if (destinationDir != null ? !destinationDir.equals(that.destinationDir) :that.destinationDir != null) return false;
if (sourcePath != null ? !sourcePath.equals(that.sourcePath) :that.sourcePath != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
