package io.fabric8.kubernetes.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class AzureFileVolumeSourceFluentImpl<T extends AzureFileVolumeSourceFluent<T>> extends BaseFluent<T> implements AzureFileVolumeSourceFluent<T>{

     Boolean readOnly;     String secretName;     String shareName;     Map<String, Object> additionalProperties = new HashMap();
public AzureFileVolumeSourceFluentImpl(){
    
}
public AzureFileVolumeSourceFluentImpl( AzureFileVolumeSource instance ){
    this.withReadOnly(instance.getReadOnly()); this.withSecretName(instance.getSecretName()); this.withShareName(instance.getShareName()); 
}

    public Boolean isReadOnly(){
    return this.readOnly;
    }
    public T withReadOnly( Boolean readOnly){
    this.readOnly=readOnly; return (T) this;
    }
    public String getSecretName(){
    return this.secretName;
    }
    public T withSecretName( String secretName){
    this.secretName=secretName; return (T) this;
    }
    public String getShareName(){
    return this.shareName;
    }
    public T withShareName( String shareName){
    this.shareName=shareName; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
AzureFileVolumeSourceFluentImpl that = (AzureFileVolumeSourceFluentImpl) o;
if (readOnly != null ? !readOnly.equals(that.readOnly) :that.readOnly != null) return false;
if (secretName != null ? !secretName.equals(that.secretName) :that.secretName != null) return false;
if (shareName != null ? !shareName.equals(that.shareName) :that.shareName != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
