package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import java.util.List;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class ClusterPolicyBindingBuilder extends ClusterPolicyBindingFluentImpl<ClusterPolicyBindingBuilder> implements VisitableBuilder<ClusterPolicyBinding,ClusterPolicyBindingBuilder>{

     ClusterPolicyBindingFluent<?> fluent;
public ClusterPolicyBindingBuilder(){
    this(new ClusterPolicyBinding());
}
public ClusterPolicyBindingBuilder( ClusterPolicyBindingFluent<?> fluent ){
    this(fluent, new ClusterPolicyBinding());
}
public ClusterPolicyBindingBuilder( ClusterPolicyBindingFluent<?> fluent , ClusterPolicyBinding instance ){
    this.fluent = fluent; fluent.withApiVersion(instance.getApiVersion()); fluent.withKind(instance.getKind()); fluent.withLastModified(instance.getLastModified()); fluent.withMetadata(instance.getMetadata()); fluent.withPolicyRef(instance.getPolicyRef()); fluent.withRoleBindings(instance.getRoleBindings()); 
}
public ClusterPolicyBindingBuilder( ClusterPolicyBinding instance ){
    this.fluent = this; this.withApiVersion(instance.getApiVersion()); this.withKind(instance.getKind()); this.withLastModified(instance.getLastModified()); this.withMetadata(instance.getMetadata()); this.withPolicyRef(instance.getPolicyRef()); this.withRoleBindings(instance.getRoleBindings()); 
}

public EditableClusterPolicyBinding build(){
    EditableClusterPolicyBinding buildable = new EditableClusterPolicyBinding(fluent.getApiVersion(),fluent.getKind(),fluent.getLastModified(),fluent.getMetadata(),fluent.getPolicyRef(),fluent.getRoleBindings());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ClusterPolicyBindingBuilder that = (ClusterPolicyBindingBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
