package io.fabric8.openshift.api.model;

import java.util.HashMap;
import java.io.Serializable;
import java.util.Map;
import java.util.Map;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;

public interface BuildStrategyFluent<T extends BuildStrategyFluent<T>> extends Fluent<T>{


    public CustomBuildStrategy getCustomStrategy();    public T withCustomStrategy( CustomBuildStrategy customStrategy);    public CustomStrategyNested<T> withNewCustomStrategy();    public CustomStrategyNested<T> withNewCustomStrategyLike( CustomBuildStrategy item);    public CustomStrategyNested<T> editCustomStrategy();    public DockerBuildStrategy getDockerStrategy();    public T withDockerStrategy( DockerBuildStrategy dockerStrategy);    public DockerStrategyNested<T> withNewDockerStrategy();    public DockerStrategyNested<T> withNewDockerStrategyLike( DockerBuildStrategy item);    public DockerStrategyNested<T> editDockerStrategy();    public SourceBuildStrategy getSourceStrategy();    public T withSourceStrategy( SourceBuildStrategy sourceStrategy);    public SourceStrategyNested<T> withNewSourceStrategy();    public SourceStrategyNested<T> withNewSourceStrategyLike( SourceBuildStrategy item);    public SourceStrategyNested<T> editSourceStrategy();    public String getType();    public T withType( String type);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface CustomStrategyNested<N> extends Nested<N>, CustomBuildStrategyFluent<CustomStrategyNested<N>>{
            public N endCustomStrategy();            public N and();        
}

    public interface DockerStrategyNested<N> extends Nested<N>, DockerBuildStrategyFluent<DockerStrategyNested<N>>{
            public N and();            public N endDockerStrategy();        
}

    public interface SourceStrategyNested<N> extends Nested<N>, SourceBuildStrategyFluent<SourceStrategyNested<N>>{
            public N and();            public N endSourceStrategy();        
}


}
