package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.RandomAccess;
import java.util.Map;
import java.util.List;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;

public class FSGroupStrategyOptionsFluentImpl<T extends FSGroupStrategyOptionsFluent<T>> extends BaseFluent<T> implements FSGroupStrategyOptionsFluent<T>{

     List<VisitableBuilder<IDRange, ?>> ranges = new ArrayList();     String type;     Map<String, Object> additionalProperties = new HashMap();
public FSGroupStrategyOptionsFluentImpl(){
    
}
public FSGroupStrategyOptionsFluentImpl( FSGroupStrategyOptions instance ){
    this.withRanges(instance.getRanges()); this.withType(instance.getType()); 
}

    public T addToRanges( IDRange ...items){
    for (IDRange item : items) {IDRangeBuilder builder = new IDRangeBuilder(item);_visitables.add(builder);this.ranges.add(builder);} return (T)this;
    }
    public T removeFromRanges( IDRange ...items){
    for (IDRange item : items) {IDRangeBuilder builder = new IDRangeBuilder(item);_visitables.remove(builder);this.ranges.remove(builder);} return (T)this;
    }
    public List<IDRange> getRanges(){
    return build(ranges);
    }
    public T withRanges( List<IDRange> ranges){
    this.ranges.clear();if (ranges != null) {for (IDRange item : ranges){this.addToRanges(item);}} return (T) this;
    }
    public T withRanges( IDRange ...ranges){
    this.ranges.clear(); if (ranges != null) {for (IDRange item :ranges){ this.addToRanges(item);}} return (T) this;
    }
    public RangesNested<T> addNewRange(){
    return new RangesNestedImpl<T>();
    }
    public RangesNested<T> addNewRangeLike( IDRange item){
    return new RangesNestedImpl<T>(item);
    }
    public T addNewRange( Long max,  Long min){
    return addToRanges(new IDRange(max, min));
    }
    public String getType(){
    return this.type;
    }
    public T withType( String type){
    this.type=type; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
FSGroupStrategyOptionsFluentImpl that = (FSGroupStrategyOptionsFluentImpl) o;
if (ranges != null ? !ranges.equals(that.ranges) :that.ranges != null) return false;
if (type != null ? !type.equals(that.type) :that.type != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class RangesNestedImpl<N> extends IDRangeFluentImpl<RangesNested<N>> implements RangesNested<N>{

        private final IDRangeBuilder builder;
    
             RangesNestedImpl (){
        this.builder = new IDRangeBuilder(this);
        }
             RangesNestedImpl ( IDRange item){
        this.builder = new IDRangeBuilder(this, item);
        }
    
            public N and(){
            return (N) FSGroupStrategyOptionsFluentImpl.this.addToRanges(builder.build());
        }
            public N endRange(){
            return and();
        }
    
}


}
