package io.fabric8.openshift.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.RandomAccess;
import java.util.Map;
import java.util.Map;
import java.util.List;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.HashMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.AbstractMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;

public class BuildConfigSpecBuilder extends BuildConfigSpecFluentImpl<BuildConfigSpecBuilder> implements VisitableBuilder<BuildConfigSpec,BuildConfigSpecBuilder>{

     BuildConfigSpecFluent<?> fluent;
public BuildConfigSpecBuilder(){
    this(new BuildConfigSpec());
}
public BuildConfigSpecBuilder( BuildConfigSpecFluent<?> fluent ){
    this(fluent, new BuildConfigSpec());
}
public BuildConfigSpecBuilder( BuildConfigSpecFluent<?> fluent , BuildConfigSpec instance ){
    this.fluent = fluent; fluent.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds()); fluent.withOutput(instance.getOutput()); fluent.withPostCommit(instance.getPostCommit()); fluent.withResources(instance.getResources()); fluent.withRevision(instance.getRevision()); fluent.withServiceAccount(instance.getServiceAccount()); fluent.withSource(instance.getSource()); fluent.withStrategy(instance.getStrategy()); fluent.withTriggers(instance.getTriggers()); 
}
public BuildConfigSpecBuilder( BuildConfigSpec instance ){
    this.fluent = this; this.withCompletionDeadlineSeconds(instance.getCompletionDeadlineSeconds()); this.withOutput(instance.getOutput()); this.withPostCommit(instance.getPostCommit()); this.withResources(instance.getResources()); this.withRevision(instance.getRevision()); this.withServiceAccount(instance.getServiceAccount()); this.withSource(instance.getSource()); this.withStrategy(instance.getStrategy()); this.withTriggers(instance.getTriggers()); 
}

public EditableBuildConfigSpec build(){
    EditableBuildConfigSpec buildable = new EditableBuildConfigSpec(fluent.getCompletionDeadlineSeconds(),fluent.getOutput(),fluent.getPostCommit(),fluent.getResources(),fluent.getRevision(),fluent.getServiceAccount(),fluent.getSource(),fluent.getStrategy(),fluent.getTriggers());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
BuildConfigSpecBuilder that = (BuildConfigSpecBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
