package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Builder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.Function;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;

public class DoneableSecret extends SecretFluentImpl<DoneableSecret> implements Doneable<Secret>, SecretFluent<DoneableSecret>{


    private final SecretBuilder builder;    private final Function<Secret, Secret> function;
    public DoneableSecret ( Function<Secret, Secret> function){
    this.builder=new SecretBuilder(this);this.function=function;
}
    public DoneableSecret ( Secret item,  Function<Secret, Secret> function){
    this.builder=new SecretBuilder(this, item);this.function=function;
}
    public DoneableSecret ( Secret item){
    this.builder=new SecretBuilder(this, item);this.function=new Function<Secret, Secret>() {
    public Secret apply(Secret item) {
        return item;
    }
}
;
}

    public Secret done(){
     return function.apply(builder.build());
}


}
