package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.HashMap;
import java.util.Map;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class VolumeBuilder extends VolumeFluentImpl<VolumeBuilder> implements VisitableBuilder<Volume,VolumeBuilder>{

     VolumeFluent<?> fluent;
public VolumeBuilder(){
    this(new Volume());
}
public VolumeBuilder( VolumeFluent<?> fluent ){
    this(fluent, new Volume());
}
public VolumeBuilder( VolumeFluent<?> fluent , Volume instance ){
    this.fluent = fluent; fluent.withAwsElasticBlockStore(instance.getAwsElasticBlockStore()); fluent.withCephfs(instance.getCephfs()); fluent.withCinder(instance.getCinder()); fluent.withDownwardAPI(instance.getDownwardAPI()); fluent.withEmptyDir(instance.getEmptyDir()); fluent.withFc(instance.getFc()); fluent.withFlexVolume(instance.getFlexVolume()); fluent.withFlocker(instance.getFlocker()); fluent.withGcePersistentDisk(instance.getGcePersistentDisk()); fluent.withGitRepo(instance.getGitRepo()); fluent.withGlusterfs(instance.getGlusterfs()); fluent.withHostPath(instance.getHostPath()); fluent.withIscsi(instance.getIscsi()); fluent.withMetadata(instance.getMetadata()); fluent.withName(instance.getName()); fluent.withNfs(instance.getNfs()); fluent.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); fluent.withRbd(instance.getRbd()); fluent.withSecret(instance.getSecret()); 
}
public VolumeBuilder( Volume instance ){
    this.fluent = this; this.withAwsElasticBlockStore(instance.getAwsElasticBlockStore()); this.withCephfs(instance.getCephfs()); this.withCinder(instance.getCinder()); this.withDownwardAPI(instance.getDownwardAPI()); this.withEmptyDir(instance.getEmptyDir()); this.withFc(instance.getFc()); this.withFlexVolume(instance.getFlexVolume()); this.withFlocker(instance.getFlocker()); this.withGcePersistentDisk(instance.getGcePersistentDisk()); this.withGitRepo(instance.getGitRepo()); this.withGlusterfs(instance.getGlusterfs()); this.withHostPath(instance.getHostPath()); this.withIscsi(instance.getIscsi()); this.withMetadata(instance.getMetadata()); this.withName(instance.getName()); this.withNfs(instance.getNfs()); this.withPersistentVolumeClaim(instance.getPersistentVolumeClaim()); this.withRbd(instance.getRbd()); this.withSecret(instance.getSecret()); 
}

public EditableVolume build(){
    EditableVolume buildable = new EditableVolume(fluent.getAwsElasticBlockStore(),fluent.getCephfs(),fluent.getCinder(),fluent.getDownwardAPI(),fluent.getEmptyDir(),fluent.getFc(),fluent.getFlexVolume(),fluent.getFlocker(),fluent.getGcePersistentDisk(),fluent.getGitRepo(),fluent.getGlusterfs(),fluent.getHostPath(),fluent.getIscsi(),fluent.getMetadata(),fluent.getName(),fluent.getNfs(),fluent.getPersistentVolumeClaim(),fluent.getRbd(),fluent.getSecret());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
VolumeBuilder that = (VolumeBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
