package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class EnvVarSourceFluentImpl<T extends EnvVarSourceFluent<T>> extends BaseFluent<T> implements EnvVarSourceFluent<T>{

     VisitableBuilder<ConfigMapKeySelector, ?> configMapKeyRef;     VisitableBuilder<ObjectFieldSelector, ?> fieldRef;     VisitableBuilder<SecretKeySelector, ?> secretKeyRef;     Map<String, Object> additionalProperties = new HashMap();
public EnvVarSourceFluentImpl(){
    
}
public EnvVarSourceFluentImpl( EnvVarSource instance ){
    this.withConfigMapKeyRef(instance.getConfigMapKeyRef()); this.withFieldRef(instance.getFieldRef()); this.withSecretKeyRef(instance.getSecretKeyRef()); 
}

    public ConfigMapKeySelector getConfigMapKeyRef(){
    return this.configMapKeyRef!=null?this.configMapKeyRef.build():null;
    }
    public T withConfigMapKeyRef( ConfigMapKeySelector configMapKeyRef){
    if (configMapKeyRef!=null){ this.configMapKeyRef= new ConfigMapKeySelectorBuilder(configMapKeyRef); _visitables.add(this.configMapKeyRef);} return (T) this;
    }
    public ConfigMapKeyRefNested<T> withNewConfigMapKeyRef(){
    return new ConfigMapKeyRefNestedImpl<T>();
    }
    public ConfigMapKeyRefNested<T> withNewConfigMapKeyRefLike( ConfigMapKeySelector item){
    return new ConfigMapKeyRefNestedImpl<T>(item);
    }
    public ConfigMapKeyRefNested<T> editConfigMapKeyRef(){
    return withNewConfigMapKeyRefLike(getConfigMapKeyRef());
    }
    public T withNewConfigMapKeyRef( String key,  String name){
    return withConfigMapKeyRef(new ConfigMapKeySelector(key, name));
    }
    public ObjectFieldSelector getFieldRef(){
    return this.fieldRef!=null?this.fieldRef.build():null;
    }
    public T withFieldRef( ObjectFieldSelector fieldRef){
    if (fieldRef!=null){ this.fieldRef= new ObjectFieldSelectorBuilder(fieldRef); _visitables.add(this.fieldRef);} return (T) this;
    }
    public FieldRefNested<T> withNewFieldRef(){
    return new FieldRefNestedImpl<T>();
    }
    public FieldRefNested<T> withNewFieldRefLike( ObjectFieldSelector item){
    return new FieldRefNestedImpl<T>(item);
    }
    public FieldRefNested<T> editFieldRef(){
    return withNewFieldRefLike(getFieldRef());
    }
    public T withNewFieldRef( String apiVersion,  String fieldPath){
    return withFieldRef(new ObjectFieldSelector(apiVersion, fieldPath));
    }
    public SecretKeySelector getSecretKeyRef(){
    return this.secretKeyRef!=null?this.secretKeyRef.build():null;
    }
    public T withSecretKeyRef( SecretKeySelector secretKeyRef){
    if (secretKeyRef!=null){ this.secretKeyRef= new SecretKeySelectorBuilder(secretKeyRef); _visitables.add(this.secretKeyRef);} return (T) this;
    }
    public SecretKeyRefNested<T> withNewSecretKeyRef(){
    return new SecretKeyRefNestedImpl<T>();
    }
    public SecretKeyRefNested<T> withNewSecretKeyRefLike( SecretKeySelector item){
    return new SecretKeyRefNestedImpl<T>(item);
    }
    public SecretKeyRefNested<T> editSecretKeyRef(){
    return withNewSecretKeyRefLike(getSecretKeyRef());
    }
    public T withNewSecretKeyRef( String key,  String name){
    return withSecretKeyRef(new SecretKeySelector(key, name));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
EnvVarSourceFluentImpl that = (EnvVarSourceFluentImpl) o;
if (configMapKeyRef != null ? !configMapKeyRef.equals(that.configMapKeyRef) :that.configMapKeyRef != null) return false;
if (fieldRef != null ? !fieldRef.equals(that.fieldRef) :that.fieldRef != null) return false;
if (secretKeyRef != null ? !secretKeyRef.equals(that.secretKeyRef) :that.secretKeyRef != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ConfigMapKeyRefNestedImpl<N> extends ConfigMapKeySelectorFluentImpl<ConfigMapKeyRefNested<N>> implements ConfigMapKeyRefNested<N>{

        private final ConfigMapKeySelectorBuilder builder;
    
             ConfigMapKeyRefNestedImpl (){
        this.builder = new ConfigMapKeySelectorBuilder(this);
        }
             ConfigMapKeyRefNestedImpl ( ConfigMapKeySelector item){
        this.builder = new ConfigMapKeySelectorBuilder(this, item);
        }
    
            public N endConfigMapKeyRef(){
            return and();
        }
            public N and(){
            return (N) EnvVarSourceFluentImpl.this.withConfigMapKeyRef(builder.build());
        }
    
}
    public class FieldRefNestedImpl<N> extends ObjectFieldSelectorFluentImpl<FieldRefNested<N>> implements FieldRefNested<N>{

        private final ObjectFieldSelectorBuilder builder;
    
             FieldRefNestedImpl (){
        this.builder = new ObjectFieldSelectorBuilder(this);
        }
             FieldRefNestedImpl ( ObjectFieldSelector item){
        this.builder = new ObjectFieldSelectorBuilder(this, item);
        }
    
            public N and(){
            return (N) EnvVarSourceFluentImpl.this.withFieldRef(builder.build());
        }
            public N endFieldRef(){
            return and();
        }
    
}
    public class SecretKeyRefNestedImpl<N> extends SecretKeySelectorFluentImpl<SecretKeyRefNested<N>> implements SecretKeyRefNested<N>{

        private final SecretKeySelectorBuilder builder;
    
             SecretKeyRefNestedImpl (){
        this.builder = new SecretKeySelectorBuilder(this);
        }
             SecretKeyRefNestedImpl ( SecretKeySelector item){
        this.builder = new SecretKeySelectorBuilder(this, item);
        }
    
            public N endSecretKeyRef(){
            return and();
        }
            public N and(){
            return (N) EnvVarSourceFluentImpl.this.withSecretKeyRef(builder.build());
        }
    
}


}
