package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class ContainerImageFluentImpl<T extends ContainerImageFluent<T>> extends BaseFluent<T> implements ContainerImageFluent<T>{

     List<String> repoTags = new ArrayList();     Long size;     Map<String, Object> additionalProperties = new HashMap();
public ContainerImageFluentImpl(){
    
}
public ContainerImageFluentImpl( ContainerImage instance ){
    this.withRepoTags(instance.getRepoTags()); this.withSize(instance.getSize()); 
}

    public T addToRepoTags( String ...items){
    for (String item : items) {this.repoTags.add(item);} return (T)this;
    }
    public T removeFromRepoTags( String ...items){
    for (String item : items) {this.repoTags.remove(item);} return (T)this;
    }
    public List<String> getRepoTags(){
    return this.repoTags;
    }
    public T withRepoTags( List<String> repoTags){
    this.repoTags.clear();if (repoTags != null) {for (String item : repoTags){this.addToRepoTags(item);}} return (T) this;
    }
    public T withRepoTags( String ...repoTags){
    this.repoTags.clear(); if (repoTags != null) {for (String item :repoTags){ this.addToRepoTags(item);}} return (T) this;
    }
    public Long getSize(){
    return this.size;
    }
    public T withSize( Long size){
    this.size=size; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
ContainerImageFluentImpl that = (ContainerImageFluentImpl) o;
if (repoTags != null ? !repoTags.equals(that.repoTags) :that.repoTags != null) return false;
if (size != null ? !size.equals(that.size) :that.size != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
