package io.fabric8.openshift.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;

public interface TagReferenceFluent<T extends TagReferenceFluent<T>> extends Fluent<T>{


    public T addToAnnotations( String key,  String value);    public T addToAnnotations( Map<String, String> map);    public T removeFromAnnotations( String key);    public T removeFromAnnotations( Map<String, String> map);    public Map<String, String> getAnnotations();    public T withAnnotations( Map<String, String> annotations);    public ObjectReference getFrom();    public T withFrom( ObjectReference from);    public FromNested<T> withNewFrom();    public FromNested<T> withNewFromLike( ObjectReference item);    public FromNested<T> editFrom();    public Long getGeneration();    public T withGeneration( Long generation);    public TagImportPolicy getImportPolicy();    public T withImportPolicy( TagImportPolicy importPolicy);    public ImportPolicyNested<T> withNewImportPolicy();    public ImportPolicyNested<T> withNewImportPolicyLike( TagImportPolicy item);    public ImportPolicyNested<T> editImportPolicy();    public T withNewImportPolicy( Boolean insecure,  Boolean scheduled);    public String getName();    public T withName( String name);    public Boolean isReference();    public T withReference( Boolean reference);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface FromNested<N> extends Nested<N>, ObjectReferenceFluent<FromNested<N>>{
            public N endFrom();            public N and();        
}

    public interface ImportPolicyNested<N> extends Nested<N>, TagImportPolicyFluent<ImportPolicyNested<N>>{
            public N endImportPolicy();            public N and();        
}


}
