package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.util.List;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;

public interface DeploymentConfigSpecFluent<T extends DeploymentConfigSpecFluent<T>> extends Fluent<T>{


    public Integer getReplicas();    public T withReplicas( Integer replicas);    public T addToSelector( String key,  String value);    public T addToSelector( Map<String, String> map);    public T removeFromSelector( String key);    public T removeFromSelector( Map<String, String> map);    public Map<String, String> getSelector();    public T withSelector( Map<String, String> selector);    public DeploymentStrategy getStrategy();    public T withStrategy( DeploymentStrategy strategy);    public StrategyNested<T> withNewStrategy();    public StrategyNested<T> withNewStrategyLike( DeploymentStrategy item);    public StrategyNested<T> editStrategy();    public PodTemplateSpec getTemplate();    public T withTemplate( PodTemplateSpec template);    public TemplateNested<T> withNewTemplate();    public TemplateNested<T> withNewTemplateLike( PodTemplateSpec item);    public TemplateNested<T> editTemplate();    public Boolean isTest();    public T withTest( Boolean test);    public T addToTriggers( DeploymentTriggerPolicy ...items);    public T removeFromTriggers( DeploymentTriggerPolicy ...items);    public List<DeploymentTriggerPolicy> getTriggers();    public T withTriggers( List<DeploymentTriggerPolicy> triggers);    public T withTriggers( DeploymentTriggerPolicy ...triggers);    public TriggersNested<T> addNewTrigger();    public TriggersNested<T> addNewTriggerLike( DeploymentTriggerPolicy item);    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface StrategyNested<N> extends Nested<N>, DeploymentStrategyFluent<StrategyNested<N>>{
            public N endStrategy();            public N and();        
}

    public interface TemplateNested<N> extends Nested<N>, PodTemplateSpecFluent<TemplateNested<N>>{
            public N endTemplate();            public N and();        
}

    public interface TriggersNested<N> extends Nested<N>, DeploymentTriggerPolicyFluent<TriggersNested<N>>{
            public N endTrigger();            public N and();        
}


}
