package io.fabric8.openshift.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.model.EnvVar;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.EnvVarFluentImpl;

public class CustomDeploymentStrategyParamsFluentImpl<T extends CustomDeploymentStrategyParamsFluent<T>> extends BaseFluent<T> implements CustomDeploymentStrategyParamsFluent<T>{

     List<String> command = new ArrayList();     List<VisitableBuilder<EnvVar, ?>> environment = new ArrayList();     String image;     Map<String, Object> additionalProperties = new HashMap();
public CustomDeploymentStrategyParamsFluentImpl(){
    
}
public CustomDeploymentStrategyParamsFluentImpl( CustomDeploymentStrategyParams instance ){
    this.withCommand(instance.getCommand()); this.withEnvironment(instance.getEnvironment()); this.withImage(instance.getImage()); 
}

    public T addToCommand( String ...items){
    for (String item : items) {this.command.add(item);} return (T)this;
    }
    public T removeFromCommand( String ...items){
    for (String item : items) {this.command.remove(item);} return (T)this;
    }
    public List<String> getCommand(){
    return this.command;
    }
    public T withCommand( List<String> command){
    this.command.clear();if (command != null) {for (String item : command){this.addToCommand(item);}} return (T) this;
    }
    public T withCommand( String ...command){
    this.command.clear(); if (command != null) {for (String item :command){ this.addToCommand(item);}} return (T) this;
    }
    public T addToEnvironment( EnvVar ...items){
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.add(builder);this.environment.add(builder);} return (T)this;
    }
    public T removeFromEnvironment( EnvVar ...items){
    for (EnvVar item : items) {EnvVarBuilder builder = new EnvVarBuilder(item);_visitables.remove(builder);this.environment.remove(builder);} return (T)this;
    }
    public List<EnvVar> getEnvironment(){
    return build(environment);
    }
    public T withEnvironment( List<EnvVar> environment){
    this.environment.clear();if (environment != null) {for (EnvVar item : environment){this.addToEnvironment(item);}} return (T) this;
    }
    public T withEnvironment( EnvVar ...environment){
    this.environment.clear(); if (environment != null) {for (EnvVar item :environment){ this.addToEnvironment(item);}} return (T) this;
    }
    public EnvironmentNested<T> addNewEnvironment(){
    return new EnvironmentNestedImpl<T>();
    }
    public EnvironmentNested<T> addNewEnvironmentLike( EnvVar item){
    return new EnvironmentNestedImpl<T>(item);
    }
    public String getImage(){
    return this.image;
    }
    public T withImage( String image){
    this.image=image; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
CustomDeploymentStrategyParamsFluentImpl that = (CustomDeploymentStrategyParamsFluentImpl) o;
if (command != null ? !command.equals(that.command) :that.command != null) return false;
if (environment != null ? !environment.equals(that.environment) :that.environment != null) return false;
if (image != null ? !image.equals(that.image) :that.image != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class EnvironmentNestedImpl<N> extends EnvVarFluentImpl<EnvironmentNested<N>> implements EnvironmentNested<N>{

        private final EnvVarBuilder builder;
    
             EnvironmentNestedImpl (){
        this.builder = new EnvVarBuilder(this);
        }
             EnvironmentNestedImpl ( EnvVar item){
        this.builder = new EnvVarBuilder(this, item);
        }
    
            public N endEnvironment(){
            return and();
        }
            public N and(){
            return (N) CustomDeploymentStrategyParamsFluentImpl.this.addToEnvironment(builder.build());
        }
    
}


}
