package io.fabric8.kubernetes.api.model.extensions;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import io.fabric8.kubernetes.api.model.IntOrString;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class RollingUpdateDaemonSetBuilder extends RollingUpdateDaemonSetFluentImpl<RollingUpdateDaemonSetBuilder> implements VisitableBuilder<RollingUpdateDaemonSet,RollingUpdateDaemonSetBuilder>{

     RollingUpdateDaemonSetFluent<?> fluent;
public RollingUpdateDaemonSetBuilder(){
    this(new RollingUpdateDaemonSet());
}
public RollingUpdateDaemonSetBuilder( RollingUpdateDaemonSetFluent<?> fluent ){
    this(fluent, new RollingUpdateDaemonSet());
}
public RollingUpdateDaemonSetBuilder( RollingUpdateDaemonSetFluent<?> fluent , RollingUpdateDaemonSet instance ){
    this.fluent = fluent; fluent.withMaxUnavailable(instance.getMaxUnavailable()); fluent.withMinReadySeconds(instance.getMinReadySeconds()); 
}
public RollingUpdateDaemonSetBuilder( RollingUpdateDaemonSet instance ){
    this.fluent = this; this.withMaxUnavailable(instance.getMaxUnavailable()); this.withMinReadySeconds(instance.getMinReadySeconds()); 
}

public EditableRollingUpdateDaemonSet build(){
    EditableRollingUpdateDaemonSet buildable = new EditableRollingUpdateDaemonSet(fluent.getMaxUnavailable(),fluent.getMinReadySeconds());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
RollingUpdateDaemonSetBuilder that = (RollingUpdateDaemonSetBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
