package io.fabric8.kubernetes.api.model.extensions;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class DeploymentStatusFluentImpl<T extends DeploymentStatusFluent<T>> extends BaseFluent<T> implements DeploymentStatusFluent<T>{

     Integer availableReplicas;     Integer replicas;     Integer unavailableReplicas;     Integer updatedReplicas;     Map<String, Object> additionalProperties = new HashMap();
public DeploymentStatusFluentImpl(){
    
}
public DeploymentStatusFluentImpl( DeploymentStatus instance ){
    this.withAvailableReplicas(instance.getAvailableReplicas()); this.withReplicas(instance.getReplicas()); this.withUnavailableReplicas(instance.getUnavailableReplicas()); this.withUpdatedReplicas(instance.getUpdatedReplicas()); 
}

    public Integer getAvailableReplicas(){
    return this.availableReplicas;
    }
    public T withAvailableReplicas( Integer availableReplicas){
    this.availableReplicas=availableReplicas; return (T) this;
    }
    public Integer getReplicas(){
    return this.replicas;
    }
    public T withReplicas( Integer replicas){
    this.replicas=replicas; return (T) this;
    }
    public Integer getUnavailableReplicas(){
    return this.unavailableReplicas;
    }
    public T withUnavailableReplicas( Integer unavailableReplicas){
    this.unavailableReplicas=unavailableReplicas; return (T) this;
    }
    public Integer getUpdatedReplicas(){
    return this.updatedReplicas;
    }
    public T withUpdatedReplicas( Integer updatedReplicas){
    this.updatedReplicas=updatedReplicas; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
DeploymentStatusFluentImpl that = (DeploymentStatusFluentImpl) o;
if (availableReplicas != null ? !availableReplicas.equals(that.availableReplicas) :that.availableReplicas != null) return false;
if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
if (unavailableReplicas != null ? !unavailableReplicas.equals(that.unavailableReplicas) :that.unavailableReplicas != null) return false;
if (updatedReplicas != null ? !updatedReplicas.equals(that.updatedReplicas) :that.updatedReplicas != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }



}
