package io.fabric8.kubernetes.api.model.extensions;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;

public interface DaemonSetSpecFluent<T extends DaemonSetSpecFluent<T>> extends Fluent<T>{


    public LabelSelector getSelector();    public T withSelector( LabelSelector selector);    public SelectorNested<T> withNewSelector();    public SelectorNested<T> withNewSelectorLike( LabelSelector item);    public SelectorNested<T> editSelector();    public PodTemplateSpec getTemplate();    public T withTemplate( PodTemplateSpec template);    public TemplateNested<T> withNewTemplate();    public TemplateNested<T> withNewTemplateLike( PodTemplateSpec item);    public TemplateNested<T> editTemplate();    public String getUniqueLabelKey();    public T withUniqueLabelKey( String uniqueLabelKey);    public DaemonSetUpdateStrategy getUpdateStrategy();    public T withUpdateStrategy( DaemonSetUpdateStrategy updateStrategy);    public UpdateStrategyNested<T> withNewUpdateStrategy();    public UpdateStrategyNested<T> withNewUpdateStrategyLike( DaemonSetUpdateStrategy item);    public UpdateStrategyNested<T> editUpdateStrategy();    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface SelectorNested<N> extends Nested<N>, LabelSelectorFluent<SelectorNested<N>>{
            public N endSelector();            public N and();        
}

    public interface TemplateNested<N> extends Nested<N>, PodTemplateSpecFluent<TemplateNested<N>>{
            public N endTemplate();            public N and();        
}

    public interface UpdateStrategyNested<N> extends Nested<N>, DaemonSetUpdateStrategyFluent<UpdateStrategyNested<N>>{
            public N endUpdateStrategy();            public N and();        
}


}
