package io.fabric8.kubernetes.api.model;

import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class StatusFluentImpl<T extends StatusFluent<T>> extends BaseFluent<T> implements StatusFluent<T>{

     String apiVersion;     Integer code;     VisitableBuilder<StatusDetails, ?> details;     String kind;     String message;     VisitableBuilder<ListMeta, ?> metadata;     String reason;     String status;     Map<String, Object> additionalProperties = new HashMap();
public StatusFluentImpl(){
    
}
public StatusFluentImpl( Status instance ){
    this.withApiVersion(instance.getApiVersion()); this.withCode(instance.getCode()); this.withDetails(instance.getDetails()); this.withKind(instance.getKind()); this.withMessage(instance.getMessage()); this.withMetadata(instance.getMetadata()); this.withReason(instance.getReason()); this.withStatus(instance.getStatus()); 
}

    public String getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( String apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public Integer getCode(){
    return this.code;
    }
    public T withCode( Integer code){
    this.code=code; return (T) this;
    }
    public StatusDetails getDetails(){
    return this.details!=null?this.details.build():null;
    }
    public T withDetails( StatusDetails details){
    if (details!=null){ this.details= new StatusDetailsBuilder(details); _visitables.add(this.details);} return (T) this;
    }
    public DetailsNested<T> withNewDetails(){
    return new DetailsNestedImpl<T>();
    }
    public DetailsNested<T> withNewDetailsLike( StatusDetails item){
    return new DetailsNestedImpl<T>(item);
    }
    public DetailsNested<T> editDetails(){
    return withNewDetailsLike(getDetails());
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public String getMessage(){
    return this.message;
    }
    public T withMessage( String message){
    this.message=message; return (T) this;
    }
    public ListMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ListMeta metadata){
    if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ListMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public T withNewMetadata( String resourceVersion,  String selfLink){
    return withMetadata(new ListMeta(resourceVersion, selfLink));
    }
    public String getReason(){
    return this.reason;
    }
    public T withReason( String reason){
    this.reason=reason; return (T) this;
    }
    public String getStatus(){
    return this.status;
    }
    public T withStatus( String status){
    this.status=status; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
StatusFluentImpl that = (StatusFluentImpl) o;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (code != null ? !code.equals(that.code) :that.code != null) return false;
if (details != null ? !details.equals(that.details) :that.details != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (message != null ? !message.equals(that.message) :that.message != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (reason != null ? !reason.equals(that.reason) :that.reason != null) return false;
if (status != null ? !status.equals(that.status) :that.status != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class DetailsNestedImpl<N> extends StatusDetailsFluentImpl<DetailsNested<N>> implements DetailsNested<N>{

        private final StatusDetailsBuilder builder;
    
             DetailsNestedImpl (){
        this.builder = new StatusDetailsBuilder(this);
        }
             DetailsNestedImpl ( StatusDetails item){
        this.builder = new StatusDetailsBuilder(this, item);
        }
    
            public N and(){
            return (N) StatusFluentImpl.this.withDetails(builder.build());
        }
            public N endDetails(){
            return and();
        }
    
}
    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ListMetaBuilder builder;
    
             MetadataNestedImpl (){
        this.builder = new ListMetaBuilder(this);
        }
             MetadataNestedImpl ( ListMeta item){
        this.builder = new ListMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) StatusFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}


}
