package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;

public class StatusDetailsFluentImpl<T extends StatusDetailsFluent<T>> extends BaseFluent<T> implements StatusDetailsFluent<T>{

     List<VisitableBuilder<StatusCause, ?>> causes = new ArrayList();     String group;     String kind;     String name;     Integer retryAfterSeconds;     Map<String, Object> additionalProperties = new HashMap();
public StatusDetailsFluentImpl(){
    
}
public StatusDetailsFluentImpl( StatusDetails instance ){
    this.withCauses(instance.getCauses()); this.withGroup(instance.getGroup()); this.withKind(instance.getKind()); this.withName(instance.getName()); this.withRetryAfterSeconds(instance.getRetryAfterSeconds()); 
}

    public T addToCauses( StatusCause ...items){
    for (StatusCause item : items) {StatusCauseBuilder builder = new StatusCauseBuilder(item);_visitables.add(builder);this.causes.add(builder);} return (T)this;
    }
    public T removeFromCauses( StatusCause ...items){
    for (StatusCause item : items) {StatusCauseBuilder builder = new StatusCauseBuilder(item);_visitables.remove(builder);this.causes.remove(builder);} return (T)this;
    }
    public List<StatusCause> getCauses(){
    return build(causes);
    }
    public T withCauses( List<StatusCause> causes){
    this.causes.clear();if (causes != null) {for (StatusCause item : causes){this.addToCauses(item);}} return (T) this;
    }
    public T withCauses( StatusCause ...causes){
    this.causes.clear(); if (causes != null) {for (StatusCause item :causes){ this.addToCauses(item);}} return (T) this;
    }
    public CausesNested<T> addNewCause(){
    return new CausesNestedImpl<T>();
    }
    public CausesNested<T> addNewCauseLike( StatusCause item){
    return new CausesNestedImpl<T>(item);
    }
    public T addNewCause( String field,  String message,  String reason){
    return addToCauses(new StatusCause(field, message, reason));
    }
    public String getGroup(){
    return this.group;
    }
    public T withGroup( String group){
    this.group=group; return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public String getName(){
    return this.name;
    }
    public T withName( String name){
    this.name=name; return (T) this;
    }
    public Integer getRetryAfterSeconds(){
    return this.retryAfterSeconds;
    }
    public T withRetryAfterSeconds( Integer retryAfterSeconds){
    this.retryAfterSeconds=retryAfterSeconds; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
StatusDetailsFluentImpl that = (StatusDetailsFluentImpl) o;
if (causes != null ? !causes.equals(that.causes) :that.causes != null) return false;
if (group != null ? !group.equals(that.group) :that.group != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (name != null ? !name.equals(that.name) :that.name != null) return false;
if (retryAfterSeconds != null ? !retryAfterSeconds.equals(that.retryAfterSeconds) :that.retryAfterSeconds != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class CausesNestedImpl<N> extends StatusCauseFluentImpl<CausesNested<N>> implements CausesNested<N>{

        private final StatusCauseBuilder builder;
    
             CausesNestedImpl (){
        this.builder = new StatusCauseBuilder(this);
        }
             CausesNestedImpl ( StatusCause item){
        this.builder = new StatusCauseBuilder(this, item);
        }
    
            public N endCause(){
            return and();
        }
            public N and(){
            return (N) StatusDetailsFluentImpl.this.addToCauses(builder.build());
        }
    
}


}
