package io.fabric8.kubernetes.api.model;

import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.ValidationException;
import java.util.Set;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Builder;

public class ProbeBuilder extends ProbeFluentImpl<ProbeBuilder> implements VisitableBuilder<Probe,ProbeBuilder>{

     ProbeFluent<?> fluent;
public ProbeBuilder(){
    this(new Probe());
}
public ProbeBuilder( ProbeFluent<?> fluent ){
    this(fluent, new Probe());
}
public ProbeBuilder( ProbeFluent<?> fluent , Probe instance ){
    this.fluent = fluent; fluent.withExec(instance.getExec()); fluent.withFailureThreshold(instance.getFailureThreshold()); fluent.withHttpGet(instance.getHttpGet()); fluent.withInitialDelaySeconds(instance.getInitialDelaySeconds()); fluent.withPeriodSeconds(instance.getPeriodSeconds()); fluent.withSuccessThreshold(instance.getSuccessThreshold()); fluent.withTcpSocket(instance.getTcpSocket()); fluent.withTimeoutSeconds(instance.getTimeoutSeconds()); 
}
public ProbeBuilder( Probe instance ){
    this.fluent = this; this.withExec(instance.getExec()); this.withFailureThreshold(instance.getFailureThreshold()); this.withHttpGet(instance.getHttpGet()); this.withInitialDelaySeconds(instance.getInitialDelaySeconds()); this.withPeriodSeconds(instance.getPeriodSeconds()); this.withSuccessThreshold(instance.getSuccessThreshold()); this.withTcpSocket(instance.getTcpSocket()); this.withTimeoutSeconds(instance.getTimeoutSeconds()); 
}

public EditableProbe build(){
    EditableProbe buildable = new EditableProbe(fluent.getExec(),fluent.getFailureThreshold(),fluent.getHttpGet(),fluent.getInitialDelaySeconds(),fluent.getPeriodSeconds(),fluent.getSuccessThreshold(),fluent.getTcpSocket(),fluent.getTimeoutSeconds());
validate(buildable);
return buildable;

}
public boolean equals( Object o ){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
if (!super.equals(o)) return false;
ProbeBuilder that = (ProbeBuilder) o;
if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
return true;

}

private <T> void validate(T item) {
    try {
        ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
        Validator validator = factory.getValidator();
        
        Set<ConstraintViolation<T>> violations = validator.validate(item);
        if (!violations.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Constraint Violations:\n");
            for (ConstraintViolation violation : violations) {
                sb.append("\t").append(violation.getRootBeanClass().getSimpleName()).append(" ").append(violation.getPropertyPath()).append(":").append(violation.getMessage()).append("\n");
            }
            throw new IllegalStateException(sb.toString());
        }
    } catch(ValidationException e) {
        //ignore
    }
}


}
