package io.fabric8.kubernetes.api.model.extensions;

import java.util.Map;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;

public interface ScaleFluent<T extends ScaleFluent<T>> extends Fluent<T>{


    public Scale.ApiVersion getApiVersion();    public T withApiVersion( Scale.ApiVersion apiVersion);    public String getKind();    public T withKind( String kind);    public ObjectMeta getMetadata();    public T withMetadata( ObjectMeta metadata);    public MetadataNested<T> withNewMetadata();    public MetadataNested<T> withNewMetadataLike( ObjectMeta item);    public MetadataNested<T> editMetadata();    public ScaleSpec getSpec();    public T withSpec( ScaleSpec spec);    public SpecNested<T> withNewSpec();    public SpecNested<T> withNewSpecLike( ScaleSpec item);    public SpecNested<T> editSpec();    public T withNewSpec( Integer replicas);    public ScaleStatus getStatus();    public T withStatus( ScaleStatus status);    public StatusNested<T> withNewStatus();    public StatusNested<T> withNewStatusLike( ScaleStatus item);    public StatusNested<T> editStatus();    public T addToAdditionalProperties( String key,  Object value);    public T addToAdditionalProperties( Map<String, Object> map);    public T removeFromAdditionalProperties( String key);    public T removeFromAdditionalProperties( Map<String, Object> map);    public Map<String, Object> getAdditionalProperties();    public T withAdditionalProperties( Map<String, Object> additionalProperties);
    public interface MetadataNested<N> extends Nested<N>, ObjectMetaFluent<MetadataNested<N>>{
            public N and();            public N endMetadata();        
}

    public interface SpecNested<N> extends Nested<N>, ScaleSpecFluent<SpecNested<N>>{
            public N endSpec();            public N and();        
}

    public interface StatusNested<N> extends Nested<N>, ScaleStatusFluent<StatusNested<N>>{
            public N and();            public N endStatus();        
}


}
