/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodSpecBuilder;
import io.fabric8.kubernetes.api.model.PodSpecFluentImpl;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.PodStatusBuilder;
import io.fabric8.kubernetes.api.model.PodStatusFluentImpl;
import java.util.HashMap;
import java.util.Map;

public class PodFluentImpl<T extends PodFluent<T>>
extends BaseFluent<T>
implements PodFluent<T> {
    Pod.ApiVersion apiVersion;
    String kind;
    VisitableBuilder<ObjectMeta, ?> metadata;
    VisitableBuilder<PodSpec, ?> spec;
    VisitableBuilder<PodStatus, ?> status;
    Map<String, Object> additionalProperties = new HashMap<String, Object>();

    public PodFluentImpl() {
    }

    public PodFluentImpl(Pod instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.withSpec(instance.getSpec());
        this.withStatus(instance.getStatus());
    }

    @Override
    public Pod.ApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public T withApiVersion(Pod.ApiVersion apiVersion) {
        this.apiVersion = apiVersion;
        return (T)this;
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public T withKind(String kind) {
        this.kind = kind;
        return (T)this;
    }

    @Override
    public ObjectMeta getMetadata() {
        return this.metadata != null ? (ObjectMeta)this.metadata.build() : null;
    }

    @Override
    public T withMetadata(ObjectMeta metadata) {
        if (metadata != null) {
            this.metadata = new ObjectMetaBuilder(metadata);
            this._visitables.add(this.metadata);
        }
        return (T)this;
    }

    @Override
    public PodFluent.MetadataNested<T> withNewMetadata() {
        return new MetadataNestedImpl();
    }

    @Override
    public PodFluent.MetadataNested<T> withNewMetadataLike(ObjectMeta item) {
        return new MetadataNestedImpl(item);
    }

    @Override
    public PodFluent.MetadataNested<T> editMetadata() {
        return this.withNewMetadataLike(this.getMetadata());
    }

    @Override
    public PodSpec getSpec() {
        return this.spec != null ? (PodSpec)this.spec.build() : null;
    }

    @Override
    public T withSpec(PodSpec spec) {
        if (spec != null) {
            this.spec = new PodSpecBuilder(spec);
            this._visitables.add(this.spec);
        }
        return (T)this;
    }

    @Override
    public PodFluent.SpecNested<T> withNewSpec() {
        return new SpecNestedImpl();
    }

    @Override
    public PodFluent.SpecNested<T> withNewSpecLike(PodSpec item) {
        return new SpecNestedImpl(item);
    }

    @Override
    public PodFluent.SpecNested<T> editSpec() {
        return this.withNewSpecLike(this.getSpec());
    }

    @Override
    public PodStatus getStatus() {
        return this.status != null ? (PodStatus)this.status.build() : null;
    }

    @Override
    public T withStatus(PodStatus status) {
        if (status != null) {
            this.status = new PodStatusBuilder(status);
            this._visitables.add(this.status);
        }
        return (T)this;
    }

    @Override
    public PodFluent.StatusNested<T> withNewStatus() {
        return new StatusNestedImpl();
    }

    @Override
    public PodFluent.StatusNested<T> withNewStatusLike(PodStatus item) {
        return new StatusNestedImpl(item);
    }

    @Override
    public PodFluent.StatusNested<T> editStatus() {
        return this.withNewStatusLike(this.getStatus());
    }

    @Override
    public T addToAdditionalProperties(String key, Object value) {
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (T)this;
    }

    @Override
    public T addToAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(String key) {
        if (key != null) {
            this.additionalProperties.remove(key);
        }
        return (T)this;
    }

    @Override
    public T removeFromAdditionalProperties(Map<String, Object> map) {
        if (map != null) {
            for (String key : map.keySet()) {
                this.additionalProperties.remove(key);
            }
        }
        return (T)this;
    }

    @Override
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public T withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties.clear();
        if (additionalProperties != null) {
            this.additionalProperties.putAll(additionalProperties);
        }
        return (T)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PodFluentImpl that = (PodFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals((Object)that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        if (this.metadata != null ? !this.metadata.equals(that.metadata) : that.metadata != null) {
            return false;
        }
        if (this.spec != null ? !this.spec.equals(that.spec) : that.spec != null) {
            return false;
        }
        if (this.status != null ? !this.status.equals(that.status) : that.status != null) {
            return false;
        }
        return !(this.additionalProperties != null ? !this.additionalProperties.equals(that.additionalProperties) : that.additionalProperties != null);
    }

    public class StatusNestedImpl<N>
    extends PodStatusFluentImpl<PodFluent.StatusNested<N>>
    implements PodFluent.StatusNested<N> {
        private final PodStatusBuilder builder;

        StatusNestedImpl(PodStatus item) {
            this.builder = new PodStatusBuilder(this, item);
        }

        StatusNestedImpl() {
            this.builder = new PodStatusBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodFluentImpl.this.withStatus(this.builder.build());
        }

        @Override
        public N endStatus() {
            return this.and();
        }
    }

    public class SpecNestedImpl<N>
    extends PodSpecFluentImpl<PodFluent.SpecNested<N>>
    implements PodFluent.SpecNested<N> {
        private final PodSpecBuilder builder;

        SpecNestedImpl(PodSpec item) {
            this.builder = new PodSpecBuilder(this, item);
        }

        SpecNestedImpl() {
            this.builder = new PodSpecBuilder(this);
        }

        @Override
        public N endSpec() {
            return this.and();
        }

        @Override
        public N and() {
            return (N)PodFluentImpl.this.withSpec(this.builder.build());
        }
    }

    public class MetadataNestedImpl<N>
    extends ObjectMetaFluentImpl<PodFluent.MetadataNested<N>>
    implements PodFluent.MetadataNested<N> {
        private final ObjectMetaBuilder builder;

        MetadataNestedImpl(ObjectMeta item) {
            this.builder = new ObjectMetaBuilder(this, item);
        }

        MetadataNestedImpl() {
            this.builder = new ObjectMetaBuilder(this);
        }

        @Override
        public N and() {
            return (N)PodFluentImpl.this.withMetadata(this.builder.build());
        }

        @Override
        public N endMetadata() {
            return this.and();
        }
    }
}

