package io.fabric8.kubernetes.api.model;

import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.List;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Fluent;

public class SecurityContextConstraintsFluentImpl<T extends SecurityContextConstraintsFluent<T>> extends BaseFluent<T> implements SecurityContextConstraintsFluent<T>{

     Boolean allowHostDirVolumePlugin;     Boolean allowHostIPC;     Boolean allowHostNetwork;     Boolean allowHostPID;     Boolean allowHostPorts;     Boolean allowPrivilegedContainer;     List<String> allowedCapabilities = new ArrayList();     SecurityContextConstraints.ApiVersion apiVersion;     VisitableBuilder<FSGroupStrategyOptions, ?> fsGroup;     List<String> groups = new ArrayList();     String kind;     VisitableBuilder<ObjectMeta, ?> metadata;     Integer priority;     VisitableBuilder<RunAsUserStrategyOptions, ?> runAsUser;     VisitableBuilder<SELinuxContextStrategyOptions, ?> seLinuxContext;     VisitableBuilder<SupplementalGroupsStrategyOptions, ?> supplementalGroups;     List<String> users = new ArrayList();     Map<String, Object> additionalProperties = new HashMap();
public SecurityContextConstraintsFluentImpl(){
    
}
public SecurityContextConstraintsFluentImpl( SecurityContextConstraints instance ){
    this.withAllowHostDirVolumePlugin(instance.getAllowHostDirVolumePlugin()); this.withAllowHostIPC(instance.getAllowHostIPC()); this.withAllowHostNetwork(instance.getAllowHostNetwork()); this.withAllowHostPID(instance.getAllowHostPID()); this.withAllowHostPorts(instance.getAllowHostPorts()); this.withAllowPrivilegedContainer(instance.getAllowPrivilegedContainer()); this.withAllowedCapabilities(instance.getAllowedCapabilities()); this.withApiVersion(instance.getApiVersion()); this.withFsGroup(instance.getFsGroup()); this.withGroups(instance.getGroups()); this.withKind(instance.getKind()); this.withMetadata(instance.getMetadata()); this.withPriority(instance.getPriority()); this.withRunAsUser(instance.getRunAsUser()); this.withSeLinuxContext(instance.getSeLinuxContext()); this.withSupplementalGroups(instance.getSupplementalGroups()); this.withUsers(instance.getUsers()); 
}

    public Boolean isAllowHostDirVolumePlugin(){
    return this.allowHostDirVolumePlugin;
    }
    public T withAllowHostDirVolumePlugin( Boolean allowHostDirVolumePlugin){
    this.allowHostDirVolumePlugin=allowHostDirVolumePlugin; return (T) this;
    }
    public Boolean isAllowHostIPC(){
    return this.allowHostIPC;
    }
    public T withAllowHostIPC( Boolean allowHostIPC){
    this.allowHostIPC=allowHostIPC; return (T) this;
    }
    public Boolean isAllowHostNetwork(){
    return this.allowHostNetwork;
    }
    public T withAllowHostNetwork( Boolean allowHostNetwork){
    this.allowHostNetwork=allowHostNetwork; return (T) this;
    }
    public Boolean isAllowHostPID(){
    return this.allowHostPID;
    }
    public T withAllowHostPID( Boolean allowHostPID){
    this.allowHostPID=allowHostPID; return (T) this;
    }
    public Boolean isAllowHostPorts(){
    return this.allowHostPorts;
    }
    public T withAllowHostPorts( Boolean allowHostPorts){
    this.allowHostPorts=allowHostPorts; return (T) this;
    }
    public Boolean isAllowPrivilegedContainer(){
    return this.allowPrivilegedContainer;
    }
    public T withAllowPrivilegedContainer( Boolean allowPrivilegedContainer){
    this.allowPrivilegedContainer=allowPrivilegedContainer; return (T) this;
    }
    public T addToAllowedCapabilities( String ...items){
    for (String item : items) {this.allowedCapabilities.add(item);} return (T)this;
    }
    public T removeFromAllowedCapabilities( String ...items){
    for (String item : items) {this.allowedCapabilities.remove(item);} return (T)this;
    }
    public List<String> getAllowedCapabilities(){
    return this.allowedCapabilities;
    }
    public T withAllowedCapabilities( List<String> allowedCapabilities){
    this.allowedCapabilities.clear();if (allowedCapabilities != null) {for (String item : allowedCapabilities){this.addToAllowedCapabilities(item);}} return (T) this;
    }
    public T withAllowedCapabilities( String ...allowedCapabilities){
    this.allowedCapabilities.clear(); if (allowedCapabilities != null) {for (String item :allowedCapabilities){ this.addToAllowedCapabilities(item);}} return (T) this;
    }
    public SecurityContextConstraints.ApiVersion getApiVersion(){
    return this.apiVersion;
    }
    public T withApiVersion( SecurityContextConstraints.ApiVersion apiVersion){
    this.apiVersion=apiVersion; return (T) this;
    }
    public FSGroupStrategyOptions getFsGroup(){
    return this.fsGroup!=null?this.fsGroup.build():null;
    }
    public T withFsGroup( FSGroupStrategyOptions fsGroup){
    if (fsGroup!=null){ this.fsGroup= new FSGroupStrategyOptionsBuilder(fsGroup); _visitables.add(this.fsGroup);} return (T) this;
    }
    public FsGroupNested<T> withNewFsGroup(){
    return new FsGroupNestedImpl<T>();
    }
    public FsGroupNested<T> withNewFsGroupLike( FSGroupStrategyOptions item){
    return new FsGroupNestedImpl<T>(item);
    }
    public FsGroupNested<T> editFsGroup(){
    return withNewFsGroupLike(getFsGroup());
    }
    public T addToGroups( String ...items){
    for (String item : items) {this.groups.add(item);} return (T)this;
    }
    public T removeFromGroups( String ...items){
    for (String item : items) {this.groups.remove(item);} return (T)this;
    }
    public List<String> getGroups(){
    return this.groups;
    }
    public T withGroups( List<String> groups){
    this.groups.clear();if (groups != null) {for (String item : groups){this.addToGroups(item);}} return (T) this;
    }
    public T withGroups( String ...groups){
    this.groups.clear(); if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (T) this;
    }
    public String getKind(){
    return this.kind;
    }
    public T withKind( String kind){
    this.kind=kind; return (T) this;
    }
    public ObjectMeta getMetadata(){
    return this.metadata!=null?this.metadata.build():null;
    }
    public T withMetadata( ObjectMeta metadata){
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (T) this;
    }
    public MetadataNested<T> withNewMetadata(){
    return new MetadataNestedImpl<T>();
    }
    public MetadataNested<T> withNewMetadataLike( ObjectMeta item){
    return new MetadataNestedImpl<T>(item);
    }
    public MetadataNested<T> editMetadata(){
    return withNewMetadataLike(getMetadata());
    }
    public Integer getPriority(){
    return this.priority;
    }
    public T withPriority( Integer priority){
    this.priority=priority; return (T) this;
    }
    public RunAsUserStrategyOptions getRunAsUser(){
    return this.runAsUser!=null?this.runAsUser.build():null;
    }
    public T withRunAsUser( RunAsUserStrategyOptions runAsUser){
    if (runAsUser!=null){ this.runAsUser= new RunAsUserStrategyOptionsBuilder(runAsUser); _visitables.add(this.runAsUser);} return (T) this;
    }
    public RunAsUserNested<T> withNewRunAsUser(){
    return new RunAsUserNestedImpl<T>();
    }
    public RunAsUserNested<T> withNewRunAsUserLike( RunAsUserStrategyOptions item){
    return new RunAsUserNestedImpl<T>(item);
    }
    public RunAsUserNested<T> editRunAsUser(){
    return withNewRunAsUserLike(getRunAsUser());
    }
    public T withNewRunAsUser( String type,  Long uid,  Long uidRangeMax,  Long uidRangeMin){
    return withRunAsUser(new RunAsUserStrategyOptions(type, uid, uidRangeMax, uidRangeMin));
    }
    public SELinuxContextStrategyOptions getSeLinuxContext(){
    return this.seLinuxContext!=null?this.seLinuxContext.build():null;
    }
    public T withSeLinuxContext( SELinuxContextStrategyOptions seLinuxContext){
    if (seLinuxContext!=null){ this.seLinuxContext= new SELinuxContextStrategyOptionsBuilder(seLinuxContext); _visitables.add(this.seLinuxContext);} return (T) this;
    }
    public SeLinuxContextNested<T> withNewSeLinuxContext(){
    return new SeLinuxContextNestedImpl<T>();
    }
    public SeLinuxContextNested<T> withNewSeLinuxContextLike( SELinuxContextStrategyOptions item){
    return new SeLinuxContextNestedImpl<T>(item);
    }
    public SeLinuxContextNested<T> editSeLinuxContext(){
    return withNewSeLinuxContextLike(getSeLinuxContext());
    }
    public SupplementalGroupsStrategyOptions getSupplementalGroups(){
    return this.supplementalGroups!=null?this.supplementalGroups.build():null;
    }
    public T withSupplementalGroups( SupplementalGroupsStrategyOptions supplementalGroups){
    if (supplementalGroups!=null){ this.supplementalGroups= new SupplementalGroupsStrategyOptionsBuilder(supplementalGroups); _visitables.add(this.supplementalGroups);} return (T) this;
    }
    public SupplementalGroupsNested<T> withNewSupplementalGroups(){
    return new SupplementalGroupsNestedImpl<T>();
    }
    public SupplementalGroupsNested<T> withNewSupplementalGroupsLike( SupplementalGroupsStrategyOptions item){
    return new SupplementalGroupsNestedImpl<T>(item);
    }
    public SupplementalGroupsNested<T> editSupplementalGroups(){
    return withNewSupplementalGroupsLike(getSupplementalGroups());
    }
    public T addToUsers( String ...items){
    for (String item : items) {this.users.add(item);} return (T)this;
    }
    public T removeFromUsers( String ...items){
    for (String item : items) {this.users.remove(item);} return (T)this;
    }
    public List<String> getUsers(){
    return this.users;
    }
    public T withUsers( List<String> users){
    this.users.clear();if (users != null) {for (String item : users){this.addToUsers(item);}} return (T) this;
    }
    public T withUsers( String ...users){
    this.users.clear(); if (users != null) {for (String item :users){ this.addToUsers(item);}} return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
SecurityContextConstraintsFluentImpl that = (SecurityContextConstraintsFluentImpl) o;
if (allowHostDirVolumePlugin != null ? !allowHostDirVolumePlugin.equals(that.allowHostDirVolumePlugin) :that.allowHostDirVolumePlugin != null) return false;
if (allowHostIPC != null ? !allowHostIPC.equals(that.allowHostIPC) :that.allowHostIPC != null) return false;
if (allowHostNetwork != null ? !allowHostNetwork.equals(that.allowHostNetwork) :that.allowHostNetwork != null) return false;
if (allowHostPID != null ? !allowHostPID.equals(that.allowHostPID) :that.allowHostPID != null) return false;
if (allowHostPorts != null ? !allowHostPorts.equals(that.allowHostPorts) :that.allowHostPorts != null) return false;
if (allowPrivilegedContainer != null ? !allowPrivilegedContainer.equals(that.allowPrivilegedContainer) :that.allowPrivilegedContainer != null) return false;
if (allowedCapabilities != null ? !allowedCapabilities.equals(that.allowedCapabilities) :that.allowedCapabilities != null) return false;
if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
if (fsGroup != null ? !fsGroup.equals(that.fsGroup) :that.fsGroup != null) return false;
if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
if (priority != null ? !priority.equals(that.priority) :that.priority != null) return false;
if (runAsUser != null ? !runAsUser.equals(that.runAsUser) :that.runAsUser != null) return false;
if (seLinuxContext != null ? !seLinuxContext.equals(that.seLinuxContext) :that.seLinuxContext != null) return false;
if (supplementalGroups != null ? !supplementalGroups.equals(that.supplementalGroups) :that.supplementalGroups != null) return false;
if (users != null ? !users.equals(that.users) :that.users != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class FsGroupNestedImpl<N> extends FSGroupStrategyOptionsFluentImpl<FsGroupNested<N>> implements FsGroupNested<N>{

        private final FSGroupStrategyOptionsBuilder builder;
    
             FsGroupNestedImpl ( FSGroupStrategyOptions item){
        this.builder = new FSGroupStrategyOptionsBuilder(this, item);
        }
             FsGroupNestedImpl (){
        this.builder = new FSGroupStrategyOptionsBuilder(this);
        }
    
            public N and(){
            return (N) SecurityContextConstraintsFluentImpl.this.withFsGroup(builder.build());
        }
            public N endFsGroup(){
            return and();
        }
    
}
    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<MetadataNested<N>> implements MetadataNested<N>{

        private final ObjectMetaBuilder builder;
    
             MetadataNestedImpl (){
        this.builder = new ObjectMetaBuilder(this);
        }
             MetadataNestedImpl ( ObjectMeta item){
        this.builder = new ObjectMetaBuilder(this, item);
        }
    
            public N and(){
            return (N) SecurityContextConstraintsFluentImpl.this.withMetadata(builder.build());
        }
            public N endMetadata(){
            return and();
        }
    
}
    public class RunAsUserNestedImpl<N> extends RunAsUserStrategyOptionsFluentImpl<RunAsUserNested<N>> implements RunAsUserNested<N>{

        private final RunAsUserStrategyOptionsBuilder builder;
    
             RunAsUserNestedImpl (){
        this.builder = new RunAsUserStrategyOptionsBuilder(this);
        }
             RunAsUserNestedImpl ( RunAsUserStrategyOptions item){
        this.builder = new RunAsUserStrategyOptionsBuilder(this, item);
        }
    
            public N endRunAsUser(){
            return and();
        }
            public N and(){
            return (N) SecurityContextConstraintsFluentImpl.this.withRunAsUser(builder.build());
        }
    
}
    public class SeLinuxContextNestedImpl<N> extends SELinuxContextStrategyOptionsFluentImpl<SeLinuxContextNested<N>> implements SeLinuxContextNested<N>{

        private final SELinuxContextStrategyOptionsBuilder builder;
    
             SeLinuxContextNestedImpl (){
        this.builder = new SELinuxContextStrategyOptionsBuilder(this);
        }
             SeLinuxContextNestedImpl ( SELinuxContextStrategyOptions item){
        this.builder = new SELinuxContextStrategyOptionsBuilder(this, item);
        }
    
            public N and(){
            return (N) SecurityContextConstraintsFluentImpl.this.withSeLinuxContext(builder.build());
        }
            public N endSeLinuxContext(){
            return and();
        }
    
}
    public class SupplementalGroupsNestedImpl<N> extends SupplementalGroupsStrategyOptionsFluentImpl<SupplementalGroupsNested<N>> implements SupplementalGroupsNested<N>{

        private final SupplementalGroupsStrategyOptionsBuilder builder;
    
             SupplementalGroupsNestedImpl (){
        this.builder = new SupplementalGroupsStrategyOptionsBuilder(this);
        }
             SupplementalGroupsNestedImpl ( SupplementalGroupsStrategyOptions item){
        this.builder = new SupplementalGroupsStrategyOptionsBuilder(this, item);
        }
    
            public N and(){
            return (N) SecurityContextConstraintsFluentImpl.this.withSupplementalGroups(builder.build());
        }
            public N endSupplementalGroups(){
            return and();
        }
    
}


}
