package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.model.IntOrString;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.builder.Fluent;

public class RollingDeploymentStrategyParamsFluentImpl<T extends RollingDeploymentStrategyParamsFluent<T>> extends BaseFluent<T> implements RollingDeploymentStrategyParamsFluent<T>{

     Long intervalSeconds;     VisitableBuilder<IntOrString, ?> maxSurge;     VisitableBuilder<IntOrString, ?> maxUnavailable;     VisitableBuilder<LifecycleHook, ?> post;     VisitableBuilder<LifecycleHook, ?> pre;     Long timeoutSeconds;     Integer updatePercent;     Long updatePeriodSeconds;     Map<String, Object> additionalProperties = new HashMap();
public RollingDeploymentStrategyParamsFluentImpl(){
    
}
public RollingDeploymentStrategyParamsFluentImpl( RollingDeploymentStrategyParams instance ){
    this.withIntervalSeconds(instance.getIntervalSeconds()); this.withMaxSurge(instance.getMaxSurge()); this.withMaxUnavailable(instance.getMaxUnavailable()); this.withPost(instance.getPost()); this.withPre(instance.getPre()); this.withTimeoutSeconds(instance.getTimeoutSeconds()); this.withUpdatePercent(instance.getUpdatePercent()); this.withUpdatePeriodSeconds(instance.getUpdatePeriodSeconds()); 
}

    public Long getIntervalSeconds(){
    return this.intervalSeconds;
    }
    public T withIntervalSeconds( Long intervalSeconds){
    this.intervalSeconds=intervalSeconds; return (T) this;
    }
    public IntOrString getMaxSurge(){
    return this.maxSurge!=null?this.maxSurge.build():null;
    }
    public T withMaxSurge( IntOrString maxSurge){
    if (maxSurge!=null){ this.maxSurge= new IntOrStringBuilder(maxSurge); _visitables.add(this.maxSurge);} return (T) this;
    }
    public MaxSurgeNested<T> withNewMaxSurge(){
    return new MaxSurgeNestedImpl<T>();
    }
    public MaxSurgeNested<T> withNewMaxSurgeLike( IntOrString item){
    return new MaxSurgeNestedImpl<T>(item);
    }
    public MaxSurgeNested<T> editMaxSurge(){
    return withNewMaxSurgeLike(getMaxSurge());
    }
    public T withNewMaxSurge( String strVal){
    return withMaxSurge(new IntOrString(strVal));
    }
    public T withNewMaxSurge( Integer intVal){
    return withMaxSurge(new IntOrString(intVal));
    }
    public IntOrString getMaxUnavailable(){
    return this.maxUnavailable!=null?this.maxUnavailable.build():null;
    }
    public T withMaxUnavailable( IntOrString maxUnavailable){
    if (maxUnavailable!=null){ this.maxUnavailable= new IntOrStringBuilder(maxUnavailable); _visitables.add(this.maxUnavailable);} return (T) this;
    }
    public MaxUnavailableNested<T> withNewMaxUnavailable(){
    return new MaxUnavailableNestedImpl<T>();
    }
    public MaxUnavailableNested<T> withNewMaxUnavailableLike( IntOrString item){
    return new MaxUnavailableNestedImpl<T>(item);
    }
    public MaxUnavailableNested<T> editMaxUnavailable(){
    return withNewMaxUnavailableLike(getMaxUnavailable());
    }
    public T withNewMaxUnavailable( String strVal){
    return withMaxUnavailable(new IntOrString(strVal));
    }
    public T withNewMaxUnavailable( Integer intVal){
    return withMaxUnavailable(new IntOrString(intVal));
    }
    public LifecycleHook getPost(){
    return this.post!=null?this.post.build():null;
    }
    public T withPost( LifecycleHook post){
    if (post!=null){ this.post= new LifecycleHookBuilder(post); _visitables.add(this.post);} return (T) this;
    }
    public PostNested<T> withNewPost(){
    return new PostNestedImpl<T>();
    }
    public PostNested<T> withNewPostLike( LifecycleHook item){
    return new PostNestedImpl<T>(item);
    }
    public PostNested<T> editPost(){
    return withNewPostLike(getPost());
    }
    public LifecycleHook getPre(){
    return this.pre!=null?this.pre.build():null;
    }
    public T withPre( LifecycleHook pre){
    if (pre!=null){ this.pre= new LifecycleHookBuilder(pre); _visitables.add(this.pre);} return (T) this;
    }
    public PreNested<T> withNewPre(){
    return new PreNestedImpl<T>();
    }
    public PreNested<T> withNewPreLike( LifecycleHook item){
    return new PreNestedImpl<T>(item);
    }
    public PreNested<T> editPre(){
    return withNewPreLike(getPre());
    }
    public Long getTimeoutSeconds(){
    return this.timeoutSeconds;
    }
    public T withTimeoutSeconds( Long timeoutSeconds){
    this.timeoutSeconds=timeoutSeconds; return (T) this;
    }
    public Integer getUpdatePercent(){
    return this.updatePercent;
    }
    public T withUpdatePercent( Integer updatePercent){
    this.updatePercent=updatePercent; return (T) this;
    }
    public Long getUpdatePeriodSeconds(){
    return this.updatePeriodSeconds;
    }
    public T withUpdatePeriodSeconds( Long updatePeriodSeconds){
    this.updatePeriodSeconds=updatePeriodSeconds; return (T) this;
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
RollingDeploymentStrategyParamsFluentImpl that = (RollingDeploymentStrategyParamsFluentImpl) o;
if (intervalSeconds != null ? !intervalSeconds.equals(that.intervalSeconds) :that.intervalSeconds != null) return false;
if (maxSurge != null ? !maxSurge.equals(that.maxSurge) :that.maxSurge != null) return false;
if (maxUnavailable != null ? !maxUnavailable.equals(that.maxUnavailable) :that.maxUnavailable != null) return false;
if (post != null ? !post.equals(that.post) :that.post != null) return false;
if (pre != null ? !pre.equals(that.pre) :that.pre != null) return false;
if (timeoutSeconds != null ? !timeoutSeconds.equals(that.timeoutSeconds) :that.timeoutSeconds != null) return false;
if (updatePercent != null ? !updatePercent.equals(that.updatePercent) :that.updatePercent != null) return false;
if (updatePeriodSeconds != null ? !updatePeriodSeconds.equals(that.updatePeriodSeconds) :that.updatePeriodSeconds != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class MaxSurgeNestedImpl<N> extends IntOrStringFluentImpl<MaxSurgeNested<N>> implements MaxSurgeNested<N>{

        private final IntOrStringBuilder builder;
    
             MaxSurgeNestedImpl ( IntOrString item){
        this.builder = new IntOrStringBuilder(this, item);
        }
             MaxSurgeNestedImpl (){
        this.builder = new IntOrStringBuilder(this);
        }
    
            public N and(){
            return (N) RollingDeploymentStrategyParamsFluentImpl.this.withMaxSurge(builder.build());
        }
            public N endMaxSurge(){
            return and();
        }
    
}
    public class MaxUnavailableNestedImpl<N> extends IntOrStringFluentImpl<MaxUnavailableNested<N>> implements MaxUnavailableNested<N>{

        private final IntOrStringBuilder builder;
    
             MaxUnavailableNestedImpl (){
        this.builder = new IntOrStringBuilder(this);
        }
             MaxUnavailableNestedImpl ( IntOrString item){
        this.builder = new IntOrStringBuilder(this, item);
        }
    
            public N endMaxUnavailable(){
            return and();
        }
            public N and(){
            return (N) RollingDeploymentStrategyParamsFluentImpl.this.withMaxUnavailable(builder.build());
        }
    
}
    public class PostNestedImpl<N> extends LifecycleHookFluentImpl<PostNested<N>> implements PostNested<N>{

        private final LifecycleHookBuilder builder;
    
             PostNestedImpl (){
        this.builder = new LifecycleHookBuilder(this);
        }
             PostNestedImpl ( LifecycleHook item){
        this.builder = new LifecycleHookBuilder(this, item);
        }
    
            public N endPost(){
            return and();
        }
            public N and(){
            return (N) RollingDeploymentStrategyParamsFluentImpl.this.withPost(builder.build());
        }
    
}
    public class PreNestedImpl<N> extends LifecycleHookFluentImpl<PreNested<N>> implements PreNested<N>{

        private final LifecycleHookBuilder builder;
    
             PreNestedImpl (){
        this.builder = new LifecycleHookBuilder(this);
        }
             PreNestedImpl ( LifecycleHook item){
        this.builder = new LifecycleHookBuilder(this, item);
        }
    
            public N and(){
            return (N) RollingDeploymentStrategyParamsFluentImpl.this.withPre(builder.build());
        }
            public N endPre(){
            return and();
        }
    
}


}
