package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.model.IntOrString;
import java.util.Map;
import java.util.HashMap;
import io.fabric8.kubernetes.api.model.IntOrStringBuilder;
import io.fabric8.kubernetes.api.model.IntOrStringFluent;
import io.fabric8.kubernetes.api.builder.Visitable;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.IntOrStringFluentImpl;
import io.fabric8.kubernetes.api.builder.Fluent;

public class IngressBackendFluentImpl<T extends IngressBackendFluent<T>> extends BaseFluent<T> implements IngressBackendFluent<T>{

     String serviceName;     VisitableBuilder<IntOrString, ?> servicePort;     Map<String, Object> additionalProperties = new HashMap();
public IngressBackendFluentImpl(){
    
}
public IngressBackendFluentImpl( IngressBackend instance ){
    this.withServiceName(instance.getServiceName()); this.withServicePort(instance.getServicePort()); 
}

    public String getServiceName(){
    return this.serviceName;
    }
    public T withServiceName( String serviceName){
    this.serviceName=serviceName; return (T) this;
    }
    public IntOrString getServicePort(){
    return this.servicePort!=null?this.servicePort.build():null;
    }
    public T withServicePort( IntOrString servicePort){
    if (servicePort!=null){ this.servicePort= new IntOrStringBuilder(servicePort); _visitables.add(this.servicePort);} return (T) this;
    }
    public ServicePortNested<T> withNewServicePort(){
    return new ServicePortNestedImpl<T>();
    }
    public ServicePortNested<T> withNewServicePortLike( IntOrString item){
    return new ServicePortNestedImpl<T>(item);
    }
    public ServicePortNested<T> editServicePort(){
    return withNewServicePortLike(getServicePort());
    }
    public T withNewServicePort( Integer intVal){
    return withServicePort(new IntOrString(intVal));
    }
    public T withNewServicePort( String strVal){
    return withServicePort(new IntOrString(strVal));
    }
    public T addToAdditionalProperties( String key,  Object value){
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (T)this;
    }
    public T addToAdditionalProperties( Map<String, Object> map){
    if(map != null) { this.additionalProperties.putAll(map);} return (T)this;
    }
    public T removeFromAdditionalProperties( String key){
    if(key != null) {this.additionalProperties.remove(key);} return (T)this;
    }
    public T removeFromAdditionalProperties( Map<String, Object> map){
    if(map != null) { for(Object key : map.keySet()) {this.additionalProperties.remove(key);}} return (T)this;
    }
    public Map<String, Object> getAdditionalProperties(){
    return this.additionalProperties;
    }
    public T withAdditionalProperties( Map<String, Object> additionalProperties){
    this.additionalProperties.clear();if (additionalProperties != null) {this.additionalProperties.putAll(additionalProperties);} return (T) this;
    }
    public boolean equals( Object o){
    
if (this == o) return true;
if (o == null || getClass() != o.getClass()) return false;
IngressBackendFluentImpl that = (IngressBackendFluentImpl) o;
if (serviceName != null ? !serviceName.equals(that.serviceName) :that.serviceName != null) return false;
if (servicePort != null ? !servicePort.equals(that.servicePort) :that.servicePort != null) return false;
if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
return true;

    }

    public class ServicePortNestedImpl<N> extends IntOrStringFluentImpl<ServicePortNested<N>> implements ServicePortNested<N>{

        private final IntOrStringBuilder builder;
    
             ServicePortNestedImpl (){
        this.builder = new IntOrStringBuilder(this);
        }
             ServicePortNestedImpl ( IntOrString item){
        this.builder = new IntOrStringBuilder(this, item);
        }
    
            public N and(){
            return (N) IngressBackendFluentImpl.this.withServicePort(builder.build());
        }
            public N endServicePort(){
            return and();
        }
    
}


}
